<?php

require '../Medoo.php';
require '../pagination.class.php';

use Medoo\Medoo;

$database = new Medoo([
  'database_type' => 'mysql',
  'database_name' => 'danteclub',
  'server' => 'localhost',
  'username' => 'ockton',
  'password' => 'drpepper00!!',
  'charset' => 'utf8',
]);

$datas = $database->select('danteclubcalendar', [
    "danteclubcalendarid",
    "dateposted",
    "eventsubject",
    "eventdate",
    "eventprice",
    "eventtime",
    "eventdesc",
    "eventopen",
    "eventprivate"
], [
    "ORDER" => ["id" => "ASC"],
]);
?>


<!DOCTYPE html>
<html lang="en">

<head>

    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="">
    <meta name="author" content="">

    <title>Dante Club | Admin - Edit Events</title>

    <!-- Bootstrap Core CSS -->
    <link href="bower_components/bootstrap/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- MetisMenu CSS -->
    <!-- <link href="bower_components/metisMenu/dist/metisMenu.min.css" rel="stylesheet"> -->

    <!-- Timeline CSS -->
    <!-- <link href="dist/css/timeline.css" rel="stylesheet"> -->

    <!-- Custom CSS -->
    <link href="dist/css/sb-admin-2.css" rel="stylesheet">

    <!-- Morris Charts CSS -->
    <!-- <link href="bower_components/morrisjs/morris.css" rel="stylesheet"> -->

    <!-- Custom Fonts -->
    <link href="bower_components/font-awesome/css/font-awesome.min.css" rel="stylesheet" type="text/css">

    <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
        <script src="https://oss.maxcdn.com/libs/respond.js/1.4.2/respond.min.js"></script>
    <![endif]-->

    <style type="text/css">
        .posting {
            padding-top: 10px;
            padding-left: 10px;
            padding-right: 10px;
        }
      .page-numbers {
        /*background-color: #f00;*/
        margin: 0 auto;
        width: 100%;
        padding-bottom: 10px;
      }
      .page-numbers a:link, .page-numbers a:visited, .page-numbers a:active, .page-numbers a:focus {
       color: #000;
      }
      .selected {
        color: #999;
      }
      .btn-save {
        font-family: 'Arial', sans-serif;
        font-weight: 100;
        text-transform: uppercase;
        font-size: 0.8em;
      }
    </style>
</head>

<body>

    <div id="wrapper">

        <!-- Navigation -->
        <nav class="navbar navbar-default navbar-static-top" role="navigation" style="margin-bottom: 0">
            <div class="navbar-header">
                <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-collapse">
                    <span class="sr-only">Toggle navigation</span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                    <span class="icon-bar"></span>
                </button>
                <a class="navbar-brand" href="index.php">Dante Club Admin Panel</a>
            </div>
            <!-- /.navbar-header -->

            <ul class="nav navbar-top-links navbar-right">
              <li class="divider"></li>
              <li><a href="../index.html"><i class="fa fa-sign-out fa-fw"></i> View Site</a></li>
                <!-- /.dropdown -->
            </ul>
            <!-- /.navbar-top-links -->

            <div class="navbar-default sidebar" role="navigation">
                <div class="sidebar-nav navbar-collapse">
                <div class="spacer-div"></div>
          <ul class="nav" id="side-menu">
            <li>
              <a href="index.php"><i class="fa fa-dashboard fa-fw"></i> Dashboard</a>
            </li>
            <li>
              <a href="editposts.php"><i class="fa fa-edit fa-fw"></i> Edit news posts</a>
            </li>
            <li>
              <a href="editevents.php"><i class="fa fa-table fa-fw"></i> Edit events</a>
            </li>
          </ul>
                </div>
                <!-- /.sidebar-collapse -->
            </div>
            <!-- /.navbar-static-side -->
        </nav>

        <div id="page-wrapper">
            <div class="row">
                <div class="col-lg-12">
                    <h1 class="page-header">Edit Events</h1>
                </div>
                <!-- /.col-lg-12 -->
            </div>
            <!-- /.row -->
            <div class="row">
                <div class="col-lg-12">
                    <div class="panel panel-default">
                        <div class="panel-heading">
                            <i class="fa fa-edit fa-fw"></i> Editing Events
                        </div>
                        <!-- /.panel-heading -->
                        <div class="panel-body">

<!--  -->
<?php
        foreach($datas as $clubEvents) {
          // start the loop

          $products[] = array(
            'id' => $clubEvents['danteclubcalendarid'],
            'dateposted' => $clubEvents['dateposted'],
            'eventsubject' => $clubEvents['eventsubject'],
            'eventdesc' => $clubEvents['eventdesc'],
            'eventdate' => $clubEvents['eventdate'],
            'eventprice' => $clubEvents['eventprice'],
            'eventtime' => $clubEvents['eventtime'],
            'eventopen' => $clubEvents['eventopen'],
            'eventprivate' => $clubEvents['eventprivate'],
          );

        } // end the loop


      if (empty($products)) {
        echo "Notice: Your database appears to be empty.";
      } else {
        // If we have an array with items
        if (count($products)) {
          // Create the pagination object
          $pagination = new pagination($products, (isset($_GET['page']) ? $_GET['page'] : 1), 8);
          // Decide if the first and last links should show
          $pagination->setShowFirstAndLast(false);
          // You can overwrite the default seperator
          $pagination->setMainSeperator(' | ');
          // Parse through the pagination class
          $productPages = $pagination->getResults();
          // If we have items
          if (count($productPages) != 0) {
            // Create the page numbers
            echo $pageNumbers = '<div class="numbers">'.$pagination->getLinks($_GET).'</div>';
            // Loop through all the items in the array

            foreach ($productPages as $productArray) {
              // Show the information about the item
              // echo '<p><b>'.$productArray['postSubject'].'</b> &nbsp;</p>';
?>
                        <div class="panel panel-default posting">
                            <ul class="list-inline">
                                <li><?php echo $productArray['eventdate']; ?></li>
                                <li><strong><?php echo $productArray['eventsubject']; ?></strong></li>
                                <li><strong><?php echo $productArray['clubevents']; ?></strong></li>
                                <li><?php echo strip_tags($listdesc); ?></li>
                                <!-- // <li><?php //echo $clubEvents->eventDesc; ?></li> -->
                                <br />
                                <li><a href="editevent.php?id=<?php echo $productArray['danteclubcalendarid']; ?>"><button class="uppercase btn btn-default btn-primary btn-save">edit</button></a></li>
                                <li>
                                    <form name="" id="" action="functions.php" method="post">
                                        <input type="hidden" name="delId" value="<?php echo $productArray['danteclubcalendarid']; ?>">
                                        <input type="hidden" name="de" value="1">
                                        <button class="uppercase btn btn-default btn-danger btn-save">delete</button>
                                    </form>
                                </li>
                            </ul>
                        </div>

<!--  -->
              <?php
                  }
                  // print out the page numbers beneath the results
                  echo $pageNumbers;
                }
              }
            }
              ?>

                        </div>
                        <!-- /.panel-body -->
                    </div>
                    <!-- /.panel -->
                </div>
                <!-- /.col-lg-4 -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /#page-wrapper -->

    </div>
    <!-- /#wrapper -->

    <!-- jQuery -->
    <script src="bower_components/jquery/dist/jquery.min.js"></script>

    <!-- Bootstrap Core JavaScript -->
    <script src="bower_components/bootstrap/dist/js/bootstrap.min.js"></script>

    <!-- Metis Menu Plugin JavaScript -->
    <!-- // <script src="bower_components/metisMenu/dist/metisMenu.min.js"></script> -->

    <!-- Morris Charts JavaScript -->
    <!-- // <script src="bower_components/raphael/raphael-min.js"></script> -->
    <!-- // <script src="bower_components/morrisjs/morris.min.js"></script> -->
    <!-- // <script src="js/morris-data.js"></script> -->

    <!-- Custom Theme JavaScript -->
    <script src="dist/js/sb-admin-2.js"></script>

</body>

</html>
