<?php

require 'medoo.config.php';

$datas = $database->select('danteclubnews', [
  "danteclubnewsid",
  "dateposted",
  "postsubject",
  "posttext",
  "publicvisible"
], [
  "ORDER" => ["danteclubnewsid" => "ASC"],
  // "publicvisible" => ["1"]
]);
?>

<!DOCTYPE html>
<html lang="en">
  <head>
    <meta http-equiv="content-type" content="text/html; charset=UTF-8">
    <meta charset="utf-8">
    <title>Dante Club | Latest News</title>

    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <link href="css/bootstrap.min.css" rel="stylesheet">
    <!--[if lt IE 9]>
      <script src="//html5shim.googlecode.com/svn/trunk/html5.js"></script>
    <![endif]-->
    <link href="css/styles.css" rel="stylesheet">

    <link href='http://fonts.googleapis.com/css?family=Raleway:700,100,400' rel='stylesheet' type='text/css'>
    <!-- <link href='http://fonts.googleapis.com/css?family=Titillium+Web:400,600,300' rel='stylesheet' type='text/css'> -->
    <!-- <link href='http://fonts.googleapis.com/css?family=Lato:300,400,700' rel='stylesheet' type='text/css'> -->
    <!-- <link href='http://fonts.googleapis.com/css?family=Raleway:400,300,700' rel='stylesheet' type='text/css'> -->

    <style type="text/css">
      body {
        font-family: 'Raleway', sans-serif;
        color: #fff;
        background-color: #000;
        background-image: url('images/darkwood.png');
      }
      a:link { color: #fff; }
      a:visited { color: #fff; }
      a:active { color: #fff; }
      a:hover, a:focus { color: #fff; }
      h1, h2, h3, h4, h5, h6 {
        font-family: "Raleway";
        font-weight: 300;
      }
      .navbar-header button {
        border: none;
      }
      .navbar-default {
        background: transparent;
      }
      ul.nav a:link, ul.nav a:visited, ul.nav a:active {
        color: #fff !important;
      }
      ul.nav a:hover, ul.nav a:active {
        background-color: inherit !important;
      }
      .navbar-default {
        border: none;
      }
      .navbar {
        background-image: url('images/darkwood.png') !important;
        /*background-color: #f00 !important;*/
      }
      .nav>li.active>a,.nav>li.active>a:hover,.nav>li.active>a:focus {
        color: #555;
        background-color: #00ff00;
        border: 1px solid #ddd;
        border-bottom-color:transparent;
        cursor:default;
      }
      #headerwrap {
        margin-top: 70px;
      }
      .page-header, .row, .container, .container-fluid {
        border: none;
      }
      .page-upper {
        /*background-color: #f5f5f5;*/
        margin-bottom: 40px;
        /*padding-top: 40px;*/
        padding-bottom: 40px;
      }
      .page-upper h2 {
        text-transform: uppercase;
        font-size: 3em;
      }
      .page-footer {
        background-color: #333;
        padding-top: 20px;
        padding-bottom: 20px;
        padding-left: 40px;
        padding-right: 40px;
      }
      .map {
        padding-top: 84px;
        min-height: 370px;
      }
      .sticky-footer {
        /*background-color: #222;*/
        padding-top: 16px;
      }
      .sticky-footer, .sticky-footer a:link, .sticky-footer a:visited, .sticky-footer a:active {
        font-size: 0.9em;
        color: #999;
      }

      /* Navigation */

      .dante-nav a:link, .dante-nav a:visited, .dante-nav a:active, .dante-nav a:focus {
        color: #fff;
      }
      .dante-nav {
        padding-bottom: 6px;
        padding-left: 3.2%;
      }
      .dante-nav table {
        /*background-color: #f00;*/
        width: 960px;
        /*padding: 0;*/
        margin: 0 auto;
      }
      .dante-nav td {
        vertical-align: bottom;
      }
      .dante-nav2 {
        display: none;
      }
      @media screen and (max-width:990px) {
        .lower-logo, .footer-map {
          padding-top: 40px;
        }
        .newsletter {
          padding-top: 60px;
        }
        .sticky-footer {
          margin-bottom: 16px;
        }
        .page-upper-c, .page-upper-r {
          padding-top: 20px;
        }

        /* Navigation */

        .dante-nav table {
          display: none;
        }
        .dante-nav2 {
          display: inline;
          list-style-type: none;
        }
        .nav {
          padding-top: 16px !important;
        }
      }
      @media screen and (max-width:769px) {
        .page-upper h2 {
          font-size: 24px;
        }
        .nav-logo {
          display: none;
        }
        #headerwrap {
          margin-top: 40px;
        }
        .btn-news {
          margin: 0 auto;
          width: 100px;
        }

        /* Navigation */

        .hideme {
          display: none;
        }
      }

      /* Index Specific CSS */

      .col-wrapper h2 {
        font-weight: 300;
      }

      .facilities, .food, .events {
        font-size: 1.2em;
        /*font-weight: 100;*/
      }
      .facilities-p, .food-p, .events-p {
        font-weight: 100;
      }
      .page-upper h2 {
        font-size: 2.8em;
      }
      .the-history {
        width: 90%;
        margin: 0 auto;
        padding-top: 10px;
        font-size: 1.2em;
        font-family: 'Raleway';
        font-weight: 300;
      }
      .hr-500 {
        width: 50%;
      }
      .page-lower {
        padding-top: 60px;
        padding-bottom: 60px;
      }
      .middle-text {
        padding-top: 20px;
      }
      .uppercase {
        text-transform: uppercase;
      }
      .middle-text p {
        font-weight: 100;
      }
      .clubnews {
        width: 80%;
        margin: 0 auto;
      }
      .news-row {
        padding-bottom: 20px;
      }
      .news-subject h3 {
        font-size: 1.2em;
        text-transform: uppercase;
      }
      .news-date {
        padding-top: 26px;
      }
      .page-numbers {
        /*background-color: #f00;*/
        margin: 0 auto;
        width: 80%;
      }
      .page-numbers a:link, .page-numbers a:visited, .page-numbers a:active, .page-numbers a:focus {
       color: #fff;
      }
      .selected {
        color: #999;
      }
      .date-flag {
        width: 112px;
        height: 70px;
        /*background-color: #ffcc00;*/
        background: url('images/date-flag.jpg');
        padding: 0;
        margin: 0;
        margin-top: 26px;
        /*float: right !important;*/
      }
      .date-flag h3 {
        margin: 0;
        padding-top: 24px;
        color: #000;
        font-size: 1.2em;
        font-weight: 600;
      }
      /* End Index CSS */
      .numbers {
        width: 80%;
        margin: 0 auto;
      }
      .news-text {
        font-weight: 100;
      }
    </style>
  </head>
  <body>

    <!-- Wrap all page content here -->

    <div id="wrap">
      <div class="navbar navbar-default navbar-fixed-top dante-nav">
        <div class="container">
          <div class="navbar-header">
            <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-collapse">
              <!-- <span class="icon-bar"></span>
              <span class="icon-bar"></span>
              <span class="icon-bar"></span> -->
              <img src="images/nav-flags.png">
            </button>
          <!-- <a class="navbar-brand" href="#">Project name</a> -->
          </div>
          <!-- nav bar collapse -->
          <div class="collapse navbar-collapse dante-nav-">
            <div class="nav nav-justified navigation text-center uppercase">
              <table>
<!--
                  <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>
-->
		<tr>
                  <td><a href="index.html">Home</a></td>
                  <td><a href="menu.html">Menu</a></td>
                  <td><a href="about.html">About the <br>Dante Club</a></td>
                  <td><a href="catering.html">Catering</a></td>
                  <td><img src="images/top-logo.png"></td>
                  <td><a href="events.html">Special <br>Events</a></td>
                  <td><a href="calendar.php">Event <br>Calendar</a></td>
                  <td><a href="contact.html">Contact</a></td>
                  <td><a href="members.php">Members <br>Area</a></td>
                  <td><a href="donation.html">Donations</a></td>
                </tr>
              </table>
              <ul class="dante-nav2 list-inline">
<!--
                <li>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</li>
-->
                <li><a href="index.html">Home</a></li>
                <li><a href="menu.html">Menu</a></li>
                <li><a href="about.html">About the <br>Dante Club</a></li>
                <li><a href="catering.html">Catering</a></li>
                <li><img src="images/nav-flags.png" class="hideme"></li>
                <li><a href="events.html">Special <br>Events</a></li>
                <li><a href="calendar.php">Event <br>Calendar</a></li>
                <li><a href="contact.html">Contact</a></li>
                <li><a href="members.php">Members <br>/Area</a></li>
                <!--<li><a href="donation.html">Donations</a></li> -->
              </ul>
            </div>
          <!--/.nav-collapse -->
          </div>
        </div>
      </div>
      <!-- Begin page content -->
      <header class="page-header" id="headerwrap">
        <img src="images/news-header-lg.jpg" class="img-responsive center-block" alt="Dante Club Sacramento" title="Dante Club Sacramento">
      </header>

      <div class="container">
        <div class="row">
          <div class="col-md-12 text-center uppercase">
            <h1>Club News</h1>
            <hr class="hr-500 center-block">
          </div>
        </div>
      </div>

      <div class="container page-upper">
      <a name="news"></a>
      <?php
        foreach($datas as $newsPosts) {
          // start the loop

          $products[] = array(
            'danteclubnewsid' => $newsPosts['danteclubnewsid'],
            'dateposted' => $newsPosts['dateposted'],
            'postsubject' => $newsPosts['postsubject'],
            'posttext' => $newsPosts['posttext'],
            'publicvisible' => $newsPosts['publicvisible']
          );

        } // end the loop


        if (empty($products)) {
          echo "Notice: Your database appears to be empty.";
        } else {
          // If we have an array with items
          if (count($products)) {
            // Create the pagination object
            $pagination = new pagination($products, (isset($_GET['page']) ? $_GET['page'] : 1), 8);
            // Decide if the first and last links should show
            $pagination->setShowFirstAndLast(false);
            // You can overwrite the default seperator
            $pagination->setMainSeperator(' | ');
            // Parse through the pagination class
            $productPages = $pagination->getResults();
            // If we have items
            if (count($productPages) != 0) {
              // Create the page numbers
              echo $pageNumbers = '<div class="numbers">'.$pagination->getLinks($_GET).'</div>';
              // Loop through all the items in the array

              foreach ($productPages as $productArray) {
                // Show the information about the item
                    // echo '<p><b>'.$productArray['postSubject'].'</b> &nbsp;</p>';
      ?>

        <div class="row news-row">
          <div class="clubnews">
            <div class="col-sm-2 date-flag text-center">
              <h3><?php //echo $productArray['datePosted']; ?></h3>
            </div>
            <div class="col-md-10">
              <div class="news-subject">
                <h3><?php echo $productArray['postsubject']; ?></h3>
              </div>
              <div class="news-text">
                <?php echo $productArray['posttext']; ?>
              </div>
            </div>
          </div>
        </div>

        <?php
            }
            // print out the page numbers beneath the results
            echo $pageNumbers;
          }
        }
      }
      ?>
      </div><!-- // container -->

      <div class="container-fluid page-footer">
        <div class="container page-footer">
          <div class="row">
            <div class="col-md-4 follow-us">
              <p class="uppercase">About The Club</p>
              <hr>
              <!-- <p>The Dante Club's central location and well-stated building has hosted generations of Sacramento's local families and a number of its "royalty" for memorable events.</p> -->
              <p>The Dante Club is centrally located with ample parking and directly off Fair Oaks Boulevard.</p>
              <p>Let the professional staff coordinate your next event: Wedding, Retirement Party, Birthday Party, Business Meeting, Reunions, Monthly Groups, Fundraiser, Quinceanera.</p>
            </div>
            <div class="col-md-4 newsletter">
              <p class="uppercase">Latest News</p>
              <hr>
              <p>We love sharing our recent news. If you would like to see all our recent posts, please click the button below.</p>
              <p class="btn-news"><a href="news.php"><button type="button" class="btn-info btn-sm btn-default">READ MORE</button></a></p>
              <br />
              <div class="social-media">
                <!-- <div class="col-xs-2"><a href="#"><img src="images/gplus.png" alt="Visit us on Google Plus"></a></div> -->
                <!-- <div class="col-xs-2"><a href="#"><img src="images/unknown.png" align="Visit us at ..." title="Visit us at ..."></a></div> -->
                <div class="col-md-12"><a href="https://www.facebook.com/pages/Dante-Club/109441672431639"><img src="images/fb.png" alt="Visit us on Facebook" title="Visit us on Facebook"></a> &nbsp; &nbsp; <a href="https://www.facebook.com/pages/Dante-Club/109441672431639">Visit us on Facebook</a></div>
                <!-- <div class="col-xs-2"><a href="#"><img src="images/Be.png" alt="Visit us at ..." title="Visit us on ..."></a></div> -->
                <!-- <div class="col-xs-2"><a href="#"><img src="images/twitter.png" alt="Visit us on Twitter" title="Visit us on Twitter"></a></div> -->
                <!-- <div class="col-xs-2"><a href="#"><img src="images/in.png" alt="Visit us at Linked In" title="Visit us at Linked In"></a></div> -->
              </div>
            </div>
            <div class="col-md-4 text-center footer-map">
              <a href="contact.html"><img src="images/map.png" alt="Google Maps" title="Google Maps"></a>
            </div>
          </div>
        </div>
      </div>
    </div>

    <!-- // end page wrap -->

    <div id="footer" class="sticky-footer">
      <div class="container-fluid text-center">
        <div class="col-md-6">Copyright &copy; 2015 | Dante Club, all rights reserved.</div>
        <div class="col-md-6 uppercase"><a href="members.php">Members Area</a> | <a href="privacy.html">Privacy Policy</a> | <a href="alighieri.html">Dante alighieri</a> | <a href="contact.html">Contact</a></div>
      </div>
    </div>

    <!-- script references -->

    <script src="http://ajax.googleapis.com/ajax/libs/jquery/2.0.2/jquery.min.js"></script>
    <script src="js/bootstrap.min.js"></script>

  </body>
</html>
