<meta http-equiv="refresh" content="5">


<style>
/**
 * Custom Web Fonts
 */
@import url(https://fonts.googleapis.com/css?family=Titillium+Web:200,400,600);


/**
 * Variables
 */

$bp-small: 48em; // 768px
$bp-medium: 64em; // 1024px
$bp-large: 85.375em; // 1366px
$bp-xlarge: 120em; // 1920px
$bp-xxlarge: 160em; // 2560px

// Media Queries
$mq-small: "(min-width: #{$bp-small})";
$mq-medium: "(min-width: #{$bp-medium})";
$mq-large: "(min-width: #{$bp-large})";
$mq-xlarge: "(min-width: #{$bp-xlarge})";
$mq-xxlarge: "(min-width: #{$bp-xxlarge})";
$mq-retina: "(-webkit-min-device-pixel-ratio: 2),(min-resolution: 192dpi)";

// Font-Size
$base-font-size: 1em;

// Line-Height
$base-line-height: 1.5;
$header-line-height: 1.25;

// Spacing
$base-spacing: $base-font-size;

// Colors
$black: #151515;
$dark-grey: #242424;
$grey: #666;
$base-accent-color: #FC4842;
$base-font-color: #CCC;

// Transition Settings
$base-transition-duration: .3s;
$base-transition-timing: ease-in-out;

// Backgrounds
$base-background-color: $dark-grey;


/**
 * Base Styles
 */
*,
*:before,
*:after {
  box-sizing: border-box;
}

body {
  background-color: $base-background-color;
	color: $base-font-color;
  font-family: 'Titillium Web', sans-serif;
  font-weight: 400;
  font-size: $base-font-size;
  line-height: $base-line-height;

  @media #{$mq-medium} {
    font-size: $base-font-size*1.2;
    line-height: $base-line-height*1.2;
  }

  @media #{$mq-large} {
    font-size: $base-font-size*1.3;
  }

  @media #{$mq-xlarge} {
    font-size: $base-font-size*1.4;
  }

  @media #{$mq-xxlarge} {
    font-size: $base-font-size*1.6;
  }
}

a {
  color: $base-accent-color;
  transition: color $base-transition-duration $base-transition-timing;
  text-decoration: none;

  &:hover,
  &:focus {
    color: darken($base-accent-color, 10%);
  }
}

img {
  max-width: 100%;
}

ul {
  padding: 0;
  list-style: none;
}

.icon {
	display: inline-block;
  fill: currentColor;
}

.divider {
  position: relative;
  margin: 0 4% $base-spacing*3;
  border-bottom: 1px solid $grey;

  @media #{$mq-medium} {
    margin: 0 8% $base-spacing*3;
  }

  @media #{$mq-large} {
    margin: 0 12% $base-spacing*3;
  }

  @media #{$mq-xlarge} {
    margin: 0 18% $base-spacing*3;
  }

  svg {
    position: absolute;
    z-index: 2;
    left: 50%;
    width: $base-spacing*2;
    height: $base-spacing*2;
    margin-left: -($base-spacing);
    margin-top: -($base-spacing);
    fill: $grey;
  }

  &:before {
      content: "";
      position: absolute;
      z-index: 1;
      top: -($base-spacing*1.5);
      right: 0;
      bottom: 0;
      left: 50%;
      margin-left: -($base-spacing*1.5);
      width: $base-spacing*3;
      height: $base-spacing*3;
      background-color: $base-background-color;
    }
}


/**
 * Global
 */

.container {
  margin: 0 4%;

  @media #{$mq-medium} {
    margin: 0 8%;
  }

  @media #{$mq-large} {
    margin: 0 12%;
  }

  @media #{$mq-xlarge} {
    margin: 0 18%;
  }
}


/**
 * Typography
 */
p {
  margin: 0 0 $base-spacing;
}

@function headings($from:1, $to:6) {
    @if $from == $to {
        @return 'h#{$from}';
    } @else {
        @return 'h#{$from},' + headings($from+1, $to);
    }
}

#{headings(1,6)} {
  text-transform: uppercase;
	line-height: $header-line-height;
}


/**
 * Sections
 */
 .header {
  position: relative;
  padding: 6em 0;
  margin: 0 0 $base-spacing;
  text-align: center;

  @media #{$mq-small} {
    padding: 8em 0;
  }

  @media #{$mq-medium} {
    padding: 10em 0;
  }

  @media #{$mq-xlarge} {
    padding: 12em 0;
  }

  &:after {
    content: "";
    position: absolute;
    z-index: 2;
    top: $base-spacing;
    right: $base-spacing;
    bottom: $base-spacing;
    left: $base-spacing;
    border: 2px solid $base-font-color;

    @media #{$mq-medium} {
      top: $base-spacing*2;
      right: $base-spacing*2;
      bottom: $base-spacing*2;
      left: $base-spacing*2;
    }
  }
 }

 .header__title {
  position: relative;
  z-index: 2;
  font-weight: 200;
  letter-spacing: 0.2em;
  font-size: 1.5em;

  @media #{$mq-small} {
    font-size: 3em;
  }

  @media #{$mq-medium} {
    font-size: 4em;
  }

  @media #{$mq-large} {
    font-size: 5em;
  }
 }

 .header__img {
  position: absolute;
  width: 100%;
  z-index: 1;
  top: 50%;
  transform: translateY(-45%);
  opacity: 0.4;

  &:before {
    content: "";
    position: absolute;
    top: 0;
    right: 0;
    bottom: 0;
    left: 0;
    background: linear-gradient(to bottom, rgba($base-background-color, 0) 0%, $base-background-color 100%);
  }
 }


 /**
 * Overview
 */
 .overview {
  position: relative;
  z-index: 2;
  margin: 0 0 $base-spacing*2;
  font-size: 1.4em;
  font-weight: 200;

  @media #{$mq-medium} {
    font-size: 1.6em;
  }

  @media #{$mq-large} {
    font-size: 1.8em;
  }
 }


 /**
 * Main
 */
.main {
  margin: 0 0 $base-spacing*2;
}

 /**
 * Footer
 */
.footer {
  padding: $base-spacing*2 0;
  text-align: center;
  color: $grey;
  background-color: $black;

  svg {
    width: $base-spacing*3;
    height: $base-spacing*3;
    fill: $grey;
    margin: 0 0 $base-spacing/2;
  }

  p {
    font-size: $base-font-size/1.2;
  }
}


/*
 * Tabs
 */
.tabs {

  li {
    display: inline-block;

    &:not(:last-child):after {
      content: "/";
      display: inline-block;
      margin: 0 $base-spacing/3;
      font-weight: 300;
      color: $grey;
    }
  }

  a {
    text-transform: uppercase;
    font-weight: 600;
    letter-spacing: 0.1em;
    cursor: pointer;

    &.is-active {
      color: white;
    }
  }
}

.js-tabby .tabs-pane {
  display: none;
  visibility: hidden;
}

.tabs-pane {
  margin: 0 0 $base-spacing*4;

  &.is-active {
    display: block;
    visibility: visible;
  }
}


/*
 * Detail Image Section
 */
.detail {
  height: 0;
  padding-bottom: 40%;
  margin: 0 0 $base-spacing*2;
  background-image: url(https://public-619e3.firebaseapp.com/Death-Star/detail_sml.jpg);
  background-position: center center;
  background-size: cover;

  @media #{$mq-xlarge} and #{$mq-retina} {
    background-image: url(https://public-619e3.firebaseapp.com/Death-Star/detail_sml@2x.jpg);
  }

  @media #{$mq-medium} {
    background-image: url(https://public-619e3.firebaseapp.com/Death-Star/detail_med.jpg);
  }

  @media #{$mq-medium} and #{$mq-retina} {
    background-image: url(https://public-619e3.firebaseapp.com/Death-Star/detail_med@2x.jpg);
  }

  @media #{$mq-large} {
    background-image: url(https://public-619e3.firebaseapp.com/Death-Star/detail_lrg.jpg);
  }

  @media #{$mq-large} and #{$mq-retina} {
    background-image: url(https://public-619e3.firebaseapp.com/Death-Star/detail_lrg@2x.jpg);
  }

  @media #{$mq-xlarge} {
    background-image: url(https://public-619e3.firebaseapp.com/Death-Star/detail_xlrg.jpg);
  }

  @media #{$mq-xlarge} and #{$mq-retina} {
    background-image: url(https://public-619e3.firebaseapp.com/Death-Star/detail_lrg@2x.jpg);
  }
}
</style>

<!-- SVG Defs -->
<svg xmlns="http://www.w3.org/2000/svg" hidden>
	<symbol id="emblem">
		<title>Galactic Empire Eemblem</title>
		<path d="M44.13 36.732c-.407-.223-.81-.454-1.202-.7-.168-.106-.246-.094-.355.082-.517.84-1.114 1.623-1.744 2.383-.135.16-.207.152-.352.02-.482-.44-.983-.856-1.464-1.295-.146-.133-.218-.11-.343.026-2.683 2.953-5.974 4.855-9.88 5.687-.17.036-.222.088-.183.27.14.644.257 1.293.395 1.937.04.185.02.26-.194.297-.972.168-1.95.29-2.935.32-.187.005-.238.064-.228.24.013.228.003.456.003.684 0 .245.004.49-.002.733-.003.13.024.19.176.183 1.166-.044 2.323-.164 3.467-.387 3.865-.75 7.31-2.39 10.327-4.924 1.803-1.517 3.325-3.28 4.585-5.27.093-.146.077-.206-.073-.288m-.73-21.344c.475.873.882 1.777 1.22 2.712.058.162.053.232-.132.29-.628.198-1.246.427-1.874.624-.198.062-.22.14-.158.323.49 1.467.768 2.976.863 4.518.146 2.358-.146 4.663-.89 6.907-.055.167-.023.227.135.28.626.204 1.245.43 1.874.625.207.064.22.142.153.323-.34.916-.73 1.81-1.195 2.67-.088.162-.066.23.093.316.408.22.808.457 1.202.7.156.097.227.095.32-.084 1.74-3.305 2.6-6.825 2.62-10.46-.008-1.188-.085-2.275-.24-3.357-.374-2.586-1.18-5.03-2.4-7.337-.07-.13-.117-.16-.252-.078-.41.247-.828.486-1.252.712-.16.087-.174.156-.087.316m-6.267-9.43C33.796 3.845 30.148 2.7 26.206 2.49c-.114-.006-.23 0-.34-.02-.18-.032-.225.04-.22.21.008.456.013.912-.003 1.368-.007.208.065.254.262.26.978.02 1.948.136 2.912.298.18.03.233.086.19.28-.144.643-.26 1.292-.395 1.937-.037.176-.01.244.19.288 3.91.842 7.21 2.747 9.892 5.716.12.132.184.12.306.01.5-.442 1.013-.87 1.51-1.315.132-.118.19-.1.298.028.645.768 1.238 1.575 1.77 2.424.083.132.142.156.28.07.402-.246.81-.487 1.224-.71.185-.1.183-.18.076-.347-1.823-2.862-4.16-5.212-7.025-7.027M25.01 48.84C11.868 48.817 1.222 38.148 1.232 25.01c.01-13.13 10.697-23.8 23.824-23.785 13.15.016 23.808 10.698 23.79 23.843-.016 13.13-10.713 23.797-23.836 23.773m24.923-26.41c-.458-4.376-1.953-8.368-4.525-11.935C42.016 5.79 37.523 2.61 31.95.972c-1.802-.53-3.645-.834-5.523-.93-.104-.006-.213.008-.312-.042h-2.15c-.092.047-.192.035-.29.04-1.516.074-3.012.296-4.488.65C9.13 3.095 1.53 11.55.212 21.806c-.392 3.044-.246 6.065.48 9.05 1.282 5.268 3.985 9.68 8.1 13.204 3.818 3.272 8.24 5.205 13.236 5.82 2.932.362 5.842.22 8.712-.472 6.078-1.464 10.966-4.74 14.636-9.796 2.594-3.573 4.096-7.58 4.557-11.976.054-.508.094-1.018.14-1.527v-2.153c-.046-.508-.086-1.018-.14-1.527M27.75 38.734c-.425-2.106-.836-4.214-1.26-6.32-.035-.17-.002-.216.166-.255 1.46-.337 2.712-1.046 3.733-2.145.146-.158.22-.13.36-.006 1.598 1.403 3.203 2.798 4.798 4.204.15.132.214.115.335-.03 1.075-1.287 1.897-2.718 2.48-4.29.077-.205.057-.284-.16-.358-2.004-.68-4.002-1.373-6.005-2.052-.192-.066-.223-.135-.163-.324.447-1.416.443-2.837 0-4.253-.06-.188-.03-.258.163-.324 2.018-.683 4.032-1.38 6.05-2.065.182-.062.214-.125.147-.307-.583-1.59-1.426-3.03-2.512-4.33-.12-.142-.185-.16-.335-.028-1.6 1.41-3.212 2.813-4.816 4.22-.126.112-.193.14-.326-.004-1.028-1.114-2.28-1.85-3.763-2.182-.142-.032-.19-.074-.157-.242.423-2.097.83-4.198 1.258-6.295.043-.215-.012-.265-.2-.295-.83-.132-1.664-.225-2.524-.21-.824-.015-1.657.075-2.486.212-.156.026-.248.05-.203.27.43 2.106.84 4.215 1.264 6.32.035.173-.023.208-.16.24-1.467.327-2.708 1.052-3.73 2.147-.143.153-.216.167-.38.023-1.594-1.406-3.2-2.802-4.796-4.206-.13-.112-.192-.137-.318.014-1.084 1.29-1.92 2.724-2.514 4.3-.084.225-.034.298.183.372 2.002.677 4 1.37 6.004 2.048.195.066.217.14.16.325-.443 1.415-.448 2.836 0 4.252.06.192.026.257-.165.322-2.004.68-4.002 1.373-6.004 2.054-.19.065-.252.12-.17.335.587 1.58 1.41 3.02 2.49 4.314.124.147.19.155.336.026 1.602-1.41 3.212-2.812 4.816-4.222.128-.11.195-.133.326.01 1.025 1.107 2.28 1.822 3.75 2.16.17.038.2.086.165.255-.425 2.106-.836 4.215-1.26 6.32-.037.18.008.214.173.246 1.692.326 3.382.325 5.075 0 .167-.03.207-.07.172-.246M5.975 13.314c.412.23.82.467 1.222.717.15.095.22.08.316-.075.52-.838 1.107-1.63 1.74-2.386.113-.135.18-.175.333-.037.49.444.998.864 1.492 1.302.118.105.182.128.304-.007 2.677-2.96 5.967-4.87 9.87-5.71.208-.046.26-.11.213-.316-.136-.612-.252-1.227-.376-1.84-.063-.313-.063-.312.24-.364.957-.166 1.92-.272 2.89-.293.177-.004.222-.066.214-.23-.01-.227-.003-.455-.003-.684 0-.243-.005-.487.003-.732.005-.142-.03-.198-.19-.192-.865.036-1.725.107-2.578.238-2.806.427-5.443 1.338-7.9 2.76-3.243 1.875-5.86 4.4-7.868 7.56-.097.152-.068.21.078.29m.704 21.343c-.47-.875-.872-1.78-1.21-2.717-.055-.155-.02-.21.127-.258.626-.205 1.245-.432 1.874-.626.218-.067.23-.15.165-.344-.492-1.466-.78-2.974-.875-4.516-.143-2.357.133-4.664.878-6.91.052-.155.02-.208-.13-.257-.633-.207-1.26-.432-1.896-.635-.177-.056-.22-.112-.153-.298.34-.934.744-1.84 1.22-2.712.09-.163.065-.23-.092-.314-.408-.22-.813-.446-1.207-.69-.173-.107-.234-.056-.318.103-1.74 3.305-2.598 6.826-2.613 10.32.003 1.56.115 2.87.345 4.173.414 2.34 1.183 4.56 2.295 6.662.078.146.14.132.257.06.41-.247.823-.495 1.244-.724.165-.09.174-.16.09-.317M24.21 45.76c-1.002-.033-1.995-.152-2.982-.33-.162-.03-.194-.075-.16-.235.143-.668.265-1.34.405-2.01.032-.153 0-.218-.157-.244-.216-.035-.43-.087-.643-.14-3.657-.915-6.75-2.77-9.278-5.567-.128-.142-.196-.13-.326-.013-.497.447-1.008.877-1.503 1.326-.133.12-.192.095-.297-.03-.65-.773-1.257-1.578-1.79-2.44-.08-.13-.142-.157-.282-.07-.387.24-.78.474-1.18.687-.203.106-.24.178-.106.388 2.095 3.28 4.838 5.868 8.244 7.745 3.014 1.66 6.247 2.566 9.682 2.75.13.006.262.002.39.022.17.028.208-.044.206-.2-.008-.472-.01-.945 0-1.417.005-.175-.06-.214-.224-.22" fill-rule="evenodd"/>
	</symbol>
</svg>
<!-- SVG Defs -->


<!-- Header -->
<header role="banner" class="header">
	<h1 class="header__title">Death Star II</h1>
	<div class="header__img">
		<img 
			srcset="
				https://public-619e3.firebaseapp.com/Death-Star/death-star_sml@2x.jpg 400w,
				https://public-619e3.firebaseapp.com/Death-Star/death-star_lrg.jpg 600w,
				https://public-619e3.firebaseapp.com/Death-Star/death-star_sml@2x.jpg 800w,
				https://public-619e3.firebaseapp.com/Death-Star/death-star_lrg@2x.jpg 1200w"
			sizes ="(min-width:1336px) 75vw, 50vw"
			alt="Death Star 02">
	</div>
</header>
<!-- Header -->


<!-- Introduction -->
<div class="container">
		<p class="overview">The second Death Star, sometimes referred to as Death Star II, was a massive battle station with enough firepower to destroy an entire planet. Following the <a href="http://starwars.wikia.com/wiki/Battle_of_Yavin">Battle of Yavin</a> and the destruction of the original <a href="http://starwars.wikia.com/wiki/Death_Star">Death Star</a>, the <a href="http://starwars.wikia.com/wiki/Galactic_Empire">Galactic Empire</a> began construction on a newer and better armed battle station, one more powerful than the original. Before it could be used on the galaxy, it was ultimately destroyed by the Millennium Falcon, a YT-1300 light freighter, after a critical hit on its reactor core.</p>
</div><!-- .container -->
<!-- Introduction -->


<!-- Divider -->
<div class="divider">
	<svg class="icon" viewBox="0 0 50 50">
			<use xlink:href="#emblem"></use>
		</svg>
</div>
<!-- Divider -->


<!-- Main -->
<main class="main" role="main">

	<section class="container">

		<ul data-tabs class="tabs">
				<li>
					<a href="#design" class="is-active" data-tab>Design</a>
				</li>
				<li>
					<a href="#armaments" data-tab>Armaments</a>
				</li>
				<li>
					<a href="#power" data-tab>Power</a>
				</li>
		</ul>

		<ul data-tabs-content>

			<!-- Design -->
			<li id="design" class="tabs-pane is-active" data-tabs-pane>
				<p>The station was a large spheroid structure 160 km in diameter and featured 560 internal levels which could contain 2,471,647 passengers and crew. Significantly larger than the previous Death Star, the Death Star II would be approximately 3% the size of the Sanctuary Moon. A large concave dish in the station's northern hemisphere housed its <a href="http://starwars.wikia.com/wiki/Superlaser">superlaser</a>. Like its predecessor, a <a href="http://starwars.wikia.com/wiki/Emperor%27s_Throne_Room">throne room</a> would be installed for the Galactic Emperor.</p>
				<p>Owing to the station's stationary and not synchronous orbit, it required a tremendous force to counter Endor's gravity. Utilizing the repulsorlift field created by the <a href="http://starwars.wikia.com/wiki/Death_Star%27s_shield_generator">shield generator</a> on Endor to maintain its position, the Death Star II created earthquakes, tidal imbalances, and other geological disturbances on the surface below.</p>
			</li>
			<!-- Design -->

			<!-- Armaments -->
			<li id="armaments" class="tabs-pane" data-tabs-pane>
				<p>The most prominent weapon on the Death Star II was its impressive superlaser, which unlike the original Death Star only had a three minute recharge time. Powered by the station's hypermatter reactors, the superlaser would focus multiple lasers through massive green kyber crystals into a single destructive beam. For point-defense capabilities, it featured 15,000 heavy and standard turbolaser batteries along with 7,500 laser cannons and 5,000 ion cannons. It housed 768 tractor beam emplacements, as well as complements of <a href="http://starwars.wikia.com/wiki/TIE/LN_starfighter">TIE/LN starfighters</a> and their variants for space-based encounters and a plethora of <a href="http://starwars.wikia.com/wiki/All_Terrain_Armored_Transport">AT-AT</a> and <a href="http://starwars.wikia.com/wiki/All_Terrain_Scout_Transport">AT-STs</a> for surface operations.</p>
			</li>
			<!-- Armaments -->

			<!-- Power -->
			<li id="power" class="tabs-pane" data-tabs-pane>
				<p>The station was powered by several hypermatter reactors, the destruction of which could be catastrophic to the station.</p>
			</li>
			<!-- Power -->

		</ul>

	</section><!-- .container -->


	<section class="detail">
	</section>


	<section class="container">

		<ul data-tabs class="tabs">
				<li>
					<a href="#origins" class="is-active" data-tab>Origins</a>
				</li>
				<li>
					<a href="#destruction" data-tab>Destruction</a>
				</li>
				<li>
					<a href="#legacy" data-tab>Legacy</a>
				</li>
		</ul>

		<ul data-tabs-content>

			<!-- Origins -->
			<li id="origins" class="tabs-pane is-active" data-tabs-pane>
				<p>With the destruction of the first Death Star in the <a href="http://starwars.wikia.com/wiki/Yavin_system">Yavin system</a>, the Empire was left in a vertiginous state as the <a href="http://starwars.wikia.com/wiki/Imperial_Military/Canon">Imperial Military</a> reeled at such a sizable loss of its martial forces. With the dissolution of the <a href="http://starwars.wikia.com/wiki/Imperial_Senate">Imperial Senate</a> and increasing pirate and rebel attacks, the Emperor immediately began construction on a new and improved battle station, one more powerful and without the fatal flaw of its predecessor. To ameliorate the failings of the previous station, Emperor Palpatine executed the Originser responsible for the first station's weak spot, then cloned him to make the second station without any imperfections. Upon the station's completion, the Emperor planned on sending invasion fleets larger than any seen in centuries to blockade the rebellious worlds of <a href="http://starwars.wikia.com/wiki/Mon_Cala">Mon Cala</a> and <a href="http://starwars.wikia.com/wiki/Chandrila">Chandrila</a> until the Death Star could destroy them, effectively ending any hope the galaxy may have in defeating the Empire and its tyrannical regime.</p>
			</li>
			<!-- Origins -->

			<!-- Destruction -->
			<li id="destruction" class="tabs-pane" data-tabs-pane>
				<p>Planning to draw the Alliance into a doomed attack against the newer battle station, large portions of the <a href="http://starwars.wikia.com/wiki/Imperial_Navy">Imperial Starfleet</a> began massing in the  <a href="http://starwars.wikia.com/wiki/Hudalla_system">Hudalla system</a> in preparations for the upcoming engagement. After members of the <a href="http://starwars.wikia.com/wiki/Rebel_Alliance_Starfighter_Corps">Rebel Alliance Starfighter Corps</a> under <a href="http://starwars.wikia.com/wiki/Corona_Squadron">Corona Squadron</a> arrived in the system, the Empire immediately sent several <a href="http://starwars.wikia.com/wiki/TIE/LN_starfighter">TIE/LN starfighters</a> to destroy the vessels. Nonetheless, several ships managed to escape and bring their intel back to <a href="http://starwars.wikia.com/wiki/Alliance_High_Command">Alliance High Command</a>, which received further information given to them from the <a href="http://starwars.wikia.com/wiki/Bothan_spynet">Bothan spynet</a> regarding the Death Star's presumed capabilities, all which was purposely leaked by Palpatine. In an effort to allow its <a href="http://starwars.wikia.com/wiki/Alliance_Fleet">scattered fleet</a> time to assemble over the Outer Rim world of <a href="http://starwars.wikia.com/wiki/Sullust">Sullust</a>, the Alliance embarked on <a href="http://starwars.wikia.com/wiki/Operation_Yellow_Moon">Operation Yellow Moon</a> which aimed to distract the Imperials of the buildup until it was too late.</p>
				<p>With the station under construction over <a href="http://starwars.wikia.com/wiki/Endor">Endor</a> when  <a href="http://starwars.wikia.com/wiki/Galactic_Emperor">Emperor</a> <a href="http://starwars.wikia.com/wiki/Darth_Sidious">Palpatine</a> personally oversaw parts of the station's construction, the Rebel Alliance could not resist the opportunity to destroy not only the Empire's newest superweapon, but also its head of state. In reality, the Emperor was leading the Rebels into a trap, resulting in the <a href="http://starwars.wikia.com/wiki/Battle_of_Endor">Battle of Endor</a>. With the station protected on the ground by a <a href="http://starwars.wikia.com/wiki/SLD-26_planetary_shield_generator/Canon">SLD-26 planetary shield generator</a> guarded by elite Imperial stormtroopers, along with the largest gathering of <a href="http://starwars.wikia.com/wiki/Imperial-class_Star_Destroyer">Imperial-class Star Destroyers</a> in Imperial history and a fully functional superlaser, total victory for the Empire appeared certain. Nonetheless, the station was destroyed by <a href="http://starwars.wikia.com/wiki/Lando_Calrissian">Lando Calrissian</a>, piloting the <a href="http://starwars.wikia.com/wiki/Millennium_Falcon">Millennium Falcon</a> and his wing of starfighters during the battle, after the ground based shield generator was destroyed by a small rebel strike team who received assistance from the planet's indigenous population, of whom the Empire viewed as no real threat. With the destruction of the second Death Star and Luke Skywalker's victory in converting his father, <a href="http://starwars.wikia.com/wiki/Anakin_Skywalker">Darth Vader</a>—once more Anakin Skywalker—to hurl his master down a reactor shaft, the rebels managed not only to prevent further destruction, but presumably end the Empire's oppressive reign once and for all.</p>
			</li>
			<!-- Destruction -->

			<!-- Legacy -->
			<li id="legacy" class="tabs-pane" data-tabs-pane>
				<p>Following the destruction of the second Death Star, Imperial records would be sent into a state of disarray, with numerous missing persons and unconfirmed dead or wounded.[5] With several thousand death notices to write and records to update, the task would be pushed to the side of Imperial priorities in the days after Endor as the Rebel Alliance would capitalize on its stunning victory by pushing the shattered Imperial forces off of many worlds across the galaxy, including the Emperor's homeworld of <a href="http://starwars.wikia.com/wiki/Naboo">Naboo</a>, one of the first to fall. Holovids of the station's destruction would be disseminated across star systems while the Empire would root out and punish those responsible in spreading what it defined treasonous lies. Nonetheless, the truth of the station's destruction would eventually become known to the general citizenry, while both the Death Star I and II would continue to serve as symbol of fear and oppression for years to come, permanently leaving its mark on citizens across the galaxy. With the Empire falling apart, many believed that total victory for the now New Republic was imminent. Nonetheless over a year and four days later Imperial remnants would still be fighting the Republic for control of the galaxy, most notably during the Empire's last stand in the <a href="http://starwars.wikia.com/wiki/Battle_of_Jakku">Battle of Jakku</a>. The <a href="http://starwars.wikia.com/wiki/Galactic_Concordance">Galactic Concordance</a> would ultimately be signed mid-battle, formally ending the <a href="http://starwars.wikia.com/wiki/Galactic_Civil_War">Galactic Civil War</a> and transforming the Empire into a mere rump state.</p>
				<p>Despite the Empire's defeat at the Battle of Jakku and its total surrender, Imperial fanatics and technocrats would flee deep into the galaxy's <a href="http://starwars.wikia.com/wiki/Unknown_Region">Unknown Regions</a> where they would form the Empire's first true successor state, the <a href="http://starwars.wikia.com/wiki/First_Order">First Order</a>. A hermit kingdom led by yet another Force practitioner entranced by the destructive capabilities of the original Death Stars, he would ultimately oversee the construction of <a href="http://starwars.wikia.com/wiki/Starkiller_Base">Starkiller Base</a>, a planet-turned <a href="http://starwars.wikia.com/wiki/Superweapon">superweapon</a> capable of destroying star systems through <a href="http://starwars.wikia.com/wiki/Sub-hyperspace">sub-hyperspace</a>.</p>
			</li>
			<!-- Legacy -->

		</ul>

	</section><!-- .container -->

</main>
<!-- Main -->


<!-- Footer -->
<footer role="contentinfo" class="footer">
	<div class="container">
		<svg class="icon" viewBox="0 0 50 50">
			<use xlink:href="#emblem"></use>
		</svg>

		<p><small>All content originates from <a href="http://starwars.wikia.com/">Wookieepedia</a>, a comprehensive database that catalogues Star Wars movies, characters, and spin-offs.</small></p>
	</div><!-- .container -->
</footer>
<!-- Footer -->

<script>
/*!
 * Tabby v10.0.4: Simple, mobile-first toggle tabs.
 * (c) 2016 Chris Ferdinandi
 * MIT License
 * https://github.com/cferdinandi/tabby
 */

(function (root, factory) {
	if ( typeof define === 'function' && define.amd ) {
		define([], factory(root));
	} else if ( typeof exports === 'object' ) {
		module.exports = factory(root);
	} else {
		root.tabby = factory(root);
	}
})(typeof global !== 'undefined' ? global : this.window || this.global, function (root) {

	'use strict';

	//
	// Variables
	//

	var tabby = {}; // Object for public APIs
	var supports = 'querySelector' in document && 'addEventListener' in root && 'classList' in document.createElement('_') && 'onhashchange' in root; // Feature test
	var settings, tab;

	// Default settings
	var defaults = {
		selectorToggle: '[data-tab]',
		selectorToggleGroup: '[data-tabs]',
		selectorContent: '[data-tabs-pane]',
		selectorContentGroup: '[data-tabs-content]',
		toggleActiveClass: 'active',
		contentActiveClass: 'active',
		initClass: 'js-tabby',
		callback: function () {}
	};


	//
	// Methods
	//

	/**
	 * A simple forEach() implementation for Arrays, Objects and NodeLists
	 * @private
	 * @param {Array|Object|NodeList} collection Collection of items to iterate
	 * @param {Function} callback Callback function for each iteration
	 * @param {Array|Object|NodeList} scope Object/NodeList/Array that forEach is iterating over (aka `this`)
	 */
	var forEach = function (collection, callback, scope) {
		if (Object.prototype.toString.call(collection) === '[object Object]') {
			for (var prop in collection) {
				if (Object.prototype.hasOwnProperty.call(collection, prop)) {
					callback.call(scope, collection[prop], prop, collection);
				}
			}
		} else {
			for (var i = 0, len = collection.length; i < len; i++) {
				callback.call(scope, collection[i], i, collection);
			}
		}
	};

	/**
	 * Merge defaults with user options
	 * @private
	 * @param {Object} defaults Default settings
	 * @param {Object} options User options
	 * @returns {Object} Merged values of defaults and options
	 */
	var extend = function () {

		// Variables
		var extended = {};
		var deep = false;
		var i = 0;
		var length = arguments.length;

		// Check if a deep merge
		if ( Object.prototype.toString.call( arguments[0] ) === '[object Boolean]' ) {
			deep = arguments[0];
			i++;
		}

		// Merge the object into the extended object
		var merge = function (obj) {
			for ( var prop in obj ) {
				if ( Object.prototype.hasOwnProperty.call( obj, prop ) ) {
					// If deep merge and property is an object, merge properties
					if ( deep && Object.prototype.toString.call(obj[prop]) === '[object Object]' ) {
						extended[prop] = extend( true, extended[prop], obj[prop] );
					} else {
						extended[prop] = obj[prop];
					}
				}
			}
		};

		// Loop through each object and conduct a merge
		for ( ; i < length; i++ ) {
			var obj = arguments[i];
			merge(obj);
		}

		return extended;

	};

	/**
	 * Get the closest matching element up the DOM tree
	 * @param {Element} elem Starting element
	 * @param {String} selector Selector to match against (class, ID, or data attribute)
	 * @return {Boolean|Element} Returns false if not match found
	 */
	var getClosest = function ( elem, selector ) {

		// Variables
		var firstChar = selector.charAt(0);
		var attribute, value;

		// If selector is a data attribute, split attribute from value
		if ( firstChar === '[' ) {
			selector = selector.substr(1, selector.length - 2);
			attribute = selector.split( '=' );

			if ( attribute.length > 1 ) {
				value = true;
				attribute[1] = attribute[1].replace( /"/g, '' ).replace( /'/g, '' );
			}
		}

		// Get closest match
		for ( ; elem && elem !== document; elem = elem.parentNode ) {

			// If selector is a class
			if ( firstChar === '.' ) {
				if ( elem.classList.contains( selector.substr(1) ) ) {
					return elem;
				}
			}

			// If selector is an ID
			if ( firstChar === '#' ) {
				if ( elem.id === selector.substr(1) ) {
					return elem;
				}
			}

			// If selector is a data attribute
			if ( firstChar === '[' ) {
				if ( elem.hasAttribute( attribute[0] ) ) {
					if ( value ) {
						if ( elem.getAttribute( attribute[0] ) === attribute[1] ) {
							return elem;
						}
					} else {
						return elem;
					}
				}
			}

			// If selector is a tag
			if ( elem.tagName.toLowerCase() === selector ) {
				return elem;
			}

		}

		return null;

	};

	/**
	 * Stop YouTube, Vimeo, and HTML5 videos from playing when leaving the slide
	 * @private
	 * @param  {Element} content The content container the video is in
	 * @param  {String} activeClass The class asigned to expanded content areas
	 */
	var stopVideos = function ( content, activeClass ) {
		if ( !content.classList.contains( activeClass ) ) {
			var iframe = content.querySelector( 'iframe');
			var video = content.querySelector( 'video' );
			if ( iframe ) {
				var iframeSrc = iframe.src;
				iframe.src = iframeSrc;
			}
			if ( video ) {
				video.pause();
			}
		}
	};

	/**
	 * Toggle tab toggle active state
	 * @private
	 * @param  {Node}   toggle   The toggle element
	 * @param  {Object} settings
	 */
	var toggleToggles = function ( toggle, settings ) {

		// Variables
		var toggleGroup = getClosest( toggle, settings.selectorToggleGroup ); // The parent for the toggle group
		if ( !toggleGroup ) return;
		var toggles = toggleGroup.querySelectorAll( settings.selectorToggle ); // The toggles in the group
		var toggleList = getClosest( toggle, 'li' ); // Toggle list item (if applicable)

		// Hide each toggle
		forEach(toggles, function (toggle) {

			// Toggle class
			toggle.classList.remove( settings.toggleActiveClass );

			// If toggle is a list item, toggle class
			var toggleList = getClosest( toggle, 'li' );
			if ( toggleList ) {
				toggleList.classList.remove( settings.toggleActiveClass );
			}

		});

		// Show the selected toggle
		toggle.classList.add( settings.toggleActiveClass );
		if ( toggleList ) {
			toggleList.classList.add( settings.toggleActiveClass );
		}

	};

	/**
	 * Toggle tab active state
	 * @private
	 * @param  {String} tabID    The ID of the tab to activate
	 * @param  {Object} settings
	 */
	var toggleTabs = function ( tabID, settings ) {

		// Variables
		var tab = document.querySelector( tabID ); // The selected tab
		if ( !tab ) return;
		var tabGroup = getClosest( tab, settings.selectorContentGroup ); // The parent for the tab group
		if ( !tabGroup ) return;
		var tabs = tabGroup.querySelectorAll( settings.selectorContent ); // The tabs in the group

		// Hide each tab
		forEach(tabs, function (tab) {
			stopVideos(tab);
			tab.classList.remove( settings.contentActiveClass );
		});

		// Show the selected tab
		tab.classList.add( settings.contentActiveClass );

	};

	/**
	 * Show a tab and hide all others
	 * @public
	 * @param  {Element} toggle The element that toggled the show tab event
	 * @param  {String}  tabID The ID of the tab to show
	 * @param  {Object}  options
	 */
	tabby.toggleTab = function ( toggle, tabID, options ) {

		// Selectors and variables
		var toggleSettings = extend( settings || defaults, options || {} );  // Merge user options with defaults
		var tabs = document.querySelectorAll(tabID); // Get tab content

		// Toggle visibility of the toggles and tabs
		toggleToggles(toggle, toggleSettings);
		toggleTabs( tabID, toggleSettings );

		// Run callbacks after toggling tab
		toggleSettings.callback( toggle, tabID );

	};

	/**
	 * Handle has change event
	 * @private
	 */
	var hashChangeHandler = function () {

		// Get hash from URL
		var hash = root.location.hash;

		// If clicked tab is cached, reset it's ID
		if ( tab ) {
			tab.id = tab.getAttribute( 'data-tab-id' );
			tab = null;
		}

		// If there's a URL hash, activate tab with matching ID
		if ( !hash ) return;
		var toggle = document.querySelector('[data-tab][href*="' + hash + '"]');
		tabby.toggleTab( toggle, hash );

	};

	/**
	 * Handle toggle click events
	 * @private
	 */
	var clickHandler = function (event) {

		// Check if event target is a tab toggle, and that it's not the currently active toggle
		var toggle = getClosest( event.target, settings.selectorToggle );
		if ( !toggle || !toggle.hash || toggle.hash === root.location.hash ) return;

		// Get the tab content
		tab = document.querySelector( toggle.hash );

		// If tab content exists, save the ID as a data attribute and remove it (prevents scroll jump)
		if ( !tab ) return;
		tab.setAttribute( 'data-tab-id', tab.id );
		tab.id = '';

	};

	/**
	 * Destroy the current initialization.
	 * @public
	 */
	tabby.destroy = function () {
		if ( !settings ) return;
		document.documentElement.classList.remove( settings.initClass );
		document.removeEventListener('click', clickHandler, false);
		root.removeEventListener('hashchange', hashChangeHandler, false);
		settings = null;
		tab = null;
	};

	/**
	 * Initialize Tabby
	 * @public
	 * @param {Object} options User settings
	 */
	tabby.init = function ( options ) {

		// feature test
		if ( !supports ) return;

		// Destroy any existing initializations
		tabby.destroy();

		// Merge user options with defaults
		settings = extend( defaults, options || {} );

		// Add class to HTML element to activate conditional CSS
		document.documentElement.classList.add( settings.initClass );

		// Listen for all click events
		document.addEventListener('click', clickHandler, false);
		root.addEventListener('hashchange', hashChangeHandler, false);

		// If URL has a hash, activate hashed tab by default
		hashChangeHandler();

	};


	//
	// Public APIs
	//

	return tabby;

});


(function (win, doc) {

  'use strict';

  if (!win.addEventListener) {
    return;
  }

  var enhanceclass = 'cutsthemustard';

  doc.documentElement.className += ' ' + enhanceclass;

  tabby.init({
      toggleActiveClass: 'is-active',
      contentActiveClass: 'is-active'
  });

}(this, this.document));
</script>