<?php
require_once '../medoo.config.php';
require_once '../pagination.class.php';

$userList = $database->select('users', [
  'id',
  'username',
  'password',
  'email'
]);

$datas = $database->select('soda', [
  "itemid",
  "item",
  "itemprice",
  "dateadded"
], [
  // "ORDER" => ["itemid" => "DESC"]
  "ORDER" => ["itemid" => "ASC"]
]);

?>

<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <meta name="description" content="Custom site for editing and displaying sale items">
  <meta name="author" content="JustinHaury, All Mighty Security">

  <title>Drink Station | Admin - Dashboard - Edit Soda</title>

  <script type='text/javascript' src='http://code.jquery.com/jquery-1.9.1.js'></script>
  <script type="text/javascript" src="http://code.jquery.com/ui/1.9.2/jquery-ui.js"></script>
  <link rel="stylesheet" type="text/css" href="http://code.jquery.com/ui/1.9.2/themes/base/jquery-ui.css">

  <!-- Bootstrap Core JavaScript -->
  <script src="../bower_components/bootstrap/dist/js/bootstrap.min.js"></script>

  <!-- Bootstrap Core CSS -->
  <link href="../bower_components/bootstrap/dist/css/bootstrap.min.css" rel="stylesheet">

  <!-- Custom CSS -->
  <link href="../dist/css/sb-admin-2.css" rel="stylesheet">

  <!-- Custom Fonts -->
  <link href="../bower_components/font-awesome/css/font-awesome.min.css" rel="stylesheet" type="text/css">

  <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
  <!--[if lt IE 9]>
      <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
      <script src="https://oss.maxcdn.com/libs/respond.js/1.4.2/respond.min.js"></script>
  <![endif]-->
  <!-- <script src="../js/jquery.form.min.js"></script>  -->

  <!-- <script src="../bower_components/jquery/dist/jquery.min.js"></script> -->
  <!-- <script src="../js/jquery.form.min.js"></script>  -->


  <style type="text/css">
    .new-event {
      margin-bottom: 80px !important;
    }
    .date-form { margin: 10px; }
    label.control-label span { cursor: pointer; }
    .list-inline { padding: 10px 0 0 20px; }
  </style>

    <!-- // <script src="../js/bootstrap-datepicker.js"></script> -->
</head>

<body>

  <div id="wrapper">

    <!-- Navigation -->
    <nav class="navbar navbar-default navbar-static-top" role="navigation" style="margin-bottom: 0">
      <div class="navbar-header">
          <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-collapse">
              <span class="sr-only">Toggle navigation</span>
              <span class="icon-bar"></span>
              <span class="icon-bar"></span>
              <span class="icon-bar"></span>
          </button>
          <a class="navbar-brand" href="index.php">Drink Station Administration - Edit Soda</a>
      </div>
      <!-- /.navbar-header -->

      <ul class="nav navbar-top-links navbar-right">

          <li class="divider"></li>
          <li><a href="../index.php"><i class="fa fa-sign-out fa-fw"></i> View Site</a></li>

            <!-- /.dropdown-user -->

          <!-- /.dropdown -->
      </ul>
      <!-- /.navbar-top-links -->

      <div class="navbar-default sidebar" role="navigation">
        <div class="sidebar-nav navbar-collapse">
          <ul class="nav" id="side-menu">
            <li>
              <a href="index.php"><i class="fa fa-dashboard fa-fw"></i> Dashboard</a>
            </li>
            <li>
              <a href="add.php"><i class="fa fa-edit fa-fw"></i> Add Items</a>
            </li>
            <li>
              <a href="edit.php"><i class="fa fa-edit fa-fw"></i> Edit/Delete Items</a>
            </li>
            <!-- <li>
              <a href="addbackground.php"><i class="fa fa-edit fa-fw"></i> Add background</a>
            </li>
            <li>
              <a href="editbackground.php"><i class="fa fa-edit fa-fw"></i> Change background</a>
            </li> -->
          </ul>
        </div>
        <!-- /.sidebar-collapse -->
      </div>
      <!-- /.navbar-static-side -->
    </nav>

    <div id="page-wrapper">
      <div class="row">
        <div class="col-lg-12">
          <h1 class="page-header">Dashboard - Edit Items</h1>
        </div>
        <!-- /.col-lg-12 -->
      </div>
      <!-- /.row -->
      <div class="row">
        <div class="col-lg-8">

<?php
        foreach($datas as $itemList) {
          // start the loop

          $products[] = array(
            'itemid' => $itemList['itemid'],
            'item' => $itemList['item'],
            'itemprice' => $itemList['itemprice'],
            'dateadded' => $itemList['dateadded'],
          );

        } // end the loop

      if (empty($products)) {
        echo "Notice: Your database appears to be empty.";
      } else {
        // If we have an array with items
        if (count($products)) {
          // Create the pagination object
          $pagination = new pagination($products, (isset($_GET['page']) ? $_GET['page'] : 1), 6);
          // Decide if the first and last links should show
          $pagination->setShowFirstAndLast(false);
          // You can overwrite the default seperator
          $pagination->setMainSeperator(' | ');
          // Parse through the pagination class
          $productPages = $pagination->getResults();
          // If we have items
          if (count($productPages) != 0) {
            // Create the page numbers
            echo $pageNumbers = '<div class="numbers">'.$pagination->getLinks($_GET).'</div>';
            // Loop through all the items in the array

            foreach ($productPages as $productArray) {
              // Show the information about the item
              // echo '<p><b>'.$productArray['postSubject'].'</b> &nbsp;</p>';
?>
                        <div class="panel panel-default posting">
                            <ul class="list-inline">
                                <li><?php echo $productArray['dateadded']; ?></li>
                                <li><strong><?php echo $productArray['item']; ?></strong></li>
                                <li><strong><?php echo $productArray['itemprice']; ?></strong></li>
                                <br />
                                <li><a href="editsodas.php?id=<?php echo $productArray['itemid']; ?>"><button class="uppercase btn btn-default btn-primary btn-save">Edit</button></a></li>
                                <li>
                                    <form name="" id="" action="deletesoda.php" method="post">
                                        <input type="hidden" name="itemid" value="<?php echo $productArray['itemid']; ?>">
                                        <input type="hidden" name="itemdelete" value="1">
                                        <button class="uppercase btn btn-default btn-danger btn-save">Delete</button>
                                    </form>
                                </li>
                            </ul>
                        </div>
                        <?php //echo substr($productArray['eventdate'], -4); ?>
<?php
                }
                // print out the page numbers beneath the results
                echo $pageNumbers;
              }
            }
          }
?>

        </div>
        <!-- /.col-lg-8 -->

      </div>
        <!-- /.row -->
    </div>
    <!-- /#page-wrapper -->

  </div>
  <!-- /#wrapper -->

  <!-- jQuery -->
  <!-- <script src="../bower_components/jquery/dist/jquery.min.js"></script> -->

  <!-- Custom Theme JavaScript -->
  <script src="../dist/js/sb-admin-2.js"></script>

</body>

</html>
