<?php

require 'medoo.config.php';

$datas = $database->select('saleitems', [
  "itemid",
  "item",
  "itemprice",
  "dateadded"
], [
  "ORDER" => ["itemid" => "ASC"],
  // "publicvisible" => ["1"]
]);
?>

<!DOCTYPE html>
<html lang="en">
  <head>
    <meta http-equiv="content-type" content="text/html; charset=UTF-8">
    <meta charset="utf-8">
    <title></title>

    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <link href="css/bootstrap.min.css" rel="stylesheet">
    <!--[if lt IE 9]>
      <script src="//html5shim.googlecode.com/svn/trunk/html5.js"></script>
    <![endif]-->
    <link href="css/styles.css" rel="stylesheet">

    <link href='http://fonts.googleapis.com/css?family=Raleway:700,100,400' rel='stylesheet' type='text/css'>
    <!-- <link href='http://fonts.googleapis.com/css?family=Titillium+Web:400,600,300' rel='stylesheet' type='text/css'> -->
    <!-- <link href='http://fonts.googleapis.com/css?family=Lato:300,400,700' rel='stylesheet' type='text/css'> -->
    <!-- <link href='http://fonts.googleapis.com/css?family=Raleway:400,300,700' rel='stylesheet' type='text/css'> -->

    <style type="text/css">
    </style>

  </head>
  <body>

    <!-- Wrap all page content here -->

      <div class="container page-upper">
      <a name="items"></a>

      <?php
        foreach($datas as $itemList) {
          // start the loop

          $products[] = array(
            'itemid' => $itemList['itemid'],
            'item' => $itemList['item'],
            'itemprice' => $itemList['itemprice'],
            'dateadded' => $itemList['dateadded']
          );

        } // end the loop


        if (empty($products)) {
          echo "Notice: Your database appears to be empty.";
        } else {
          // If we have an array with items
          if (count($products)) {
            // Create the pagination object
            $pagination = new pagination($products, (isset($_GET['page']) ? $_GET['page'] : 1), 8);
            // Decide if the first and last links should show
            $pagination->setShowFirstAndLast(false);
            // You can overwrite the default seperator
            $pagination->setMainSeperator(' | ');
            // Parse through the pagination class
            $productPages = $pagination->getResults();
            // If we have items
            if (count($productPages) != 0) {
              // Create the page numbers
              echo $pageNumbers = '<div class="numbers">'.$pagination->getLinks($_GET).'</div>';
              // Loop through all the items in the array

              foreach ($productPages as $productArray) {
                // Show the information about the item
                    // echo '<p><b>'.$productArray['postSubject'].'</b> &nbsp;</p>';
      ?>

        <div class="row news-row">
          <div class="clubnews">
            <div class="col-md-10">
              <div class="news-subject">
                <h3><?php echo $productArray['item']; ?> - <small><?php echo $productArray['dateadded']; ?></small></h3>
              </div>
              <div class="news-text">
                <?php echo $productArray['itemprice']; ?>
              </div>
            </div>
          </div>
        </div>

        <?php
            }
            // print out the page numbers beneath the results
            echo $pageNumbers;
          }
        }
      }
      ?>
      </div><!-- // container -->

    </div>

    <!-- // end page wrap -->

      <br />
      <br />

    <div id="footer" class="sticky-footer">
      <div class="container-fluid text-center">
        <div class="col-md-6">Copyright &copy; 2015 | Dante Club, all rights reserved.</div>
        <div class="col-md-6 uppercase"><a href="members.php">Members Area</a> | <a href="privacy.html">Privacy Policy</a> | <a href="alighieri.html">Dante alighieri</a> | <a href="contact.html">Contact</a></div>
      </div>
    </div>

    <!-- script references -->

    <script src="http://ajax.googleapis.com/ajax/libs/jquery/2.0.2/jquery.min.js"></script>
    <script src="js/bootstrap.min.js"></script>

  </body>
</html>
