<?php

require '../medoo.config.php';

$eventList = $database->select('danteclubcalendar', [
  "danteclubcalendarid",
  "dateposted",
  "eventsubject",
  "eventdate",
  "eventprice",
  "eventtime",
  "eventdesc",
  "eventopen",
  "eventprivate"
]);
// foreach($eventList as $clubEvents) { }

$newsList = $database->select('danteclubnews', [
  'danteclubnewsid',
  'dateposted',
  'postsubject',
  'posttext',
  'publicvisible'
]);
// foreach($newsList as $clubNews) { }

?>

<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <meta name="description" content="">
  <meta name="author" content="">

  <title>Dante Club | Admin - Dashboard</title>

  <script type='text/javascript' src='http://code.jquery.com/jquery-1.9.1.js'></script>

  <script type="text/javascript" src="http://code.jquery.com/ui/1.9.2/jquery-ui.js"></script>
  <link rel="stylesheet" type="text/css" href="http://code.jquery.com/ui/1.9.2/themes/base/jquery-ui.css">

  <!-- Bootstrap Core JavaScript -->
  <script src="bower_components/bootstrap/dist/js/bootstrap.min.js"></script>

  <!-- Bootstrap Core CSS -->
  <link href="bower_components/bootstrap/dist/css/bootstrap.min.css" rel="stylesheet">

  <!-- Custom CSS -->
  <link href="dist/css/sb-admin-2.css" rel="stylesheet">

  <!-- Custom Fonts -->
  <link href="bower_components/font-awesome/css/font-awesome.min.css" rel="stylesheet" type="text/css">

  <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
  <!--[if lt IE 9]>
      <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
      <script src="https://oss.maxcdn.com/libs/respond.js/1.4.2/respond.min.js"></script>
  <![endif]-->
  <!-- <script src="../js/jquery.form.min.js"></script>  -->

    <!-- <script src="bower_components/jquery/dist/jquery.min.js"></script> -->
    <!-- <script src="../js/jquery.form.min.js"></script>  -->


  <style type="text/css">
    .new-event {
      margin-bottom: 80px !important;
    }
    .date-form { margin: 10px; }
    label.control-label span { cursor: pointer; }
  </style>

    <!-- // <script src="js/bootstrap-datepicker.js"></script> -->
  <script type='text/javascript'>
  //<![CDATA[
    $(window).load(function(){
      $(".date-picker").datepicker();

      $(".date-picker").on("change", function () {
          var id = $(this).attr("id");
          var val = $("label[for='" + id + "']").text();
          $("#msg").text(val + " changed");
      });
    });
  //]]>
  </script>


</head>

<body>

  <div id="wrapper">

    <!-- Navigation -->
    <nav class="navbar navbar-default navbar-static-top" role="navigation" style="margin-bottom: 0">
      <div class="navbar-header">
          <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-collapse">
              <span class="sr-only">Toggle navigation</span>
              <span class="icon-bar"></span>
              <span class="icon-bar"></span>
              <span class="icon-bar"></span>
          </button>
          <a class="navbar-brand" href="index.php">Dante Club Administration</a>
      </div>
      <!-- /.navbar-header -->

      <ul class="nav navbar-top-links navbar-right">

          <li class="divider"></li>
          <li><a href="../index.html"><i class="fa fa-sign-out fa-fw"></i> View Site</a></li>

            <!-- /.dropdown-user -->

          <!-- /.dropdown -->
      </ul>
      <!-- /.navbar-top-links -->

      <div class="navbar-default sidebar" role="navigation">
        <div class="sidebar-nav navbar-collapse">
          <ul class="nav" id="side-menu">
            <li>
              <a href="index.php"><i class="fa fa-dashboard fa-fw"></i> Dashboard</a>
            </li>
            <li>
              <a href="editposts.php"><i class="fa fa-edit fa-fw"></i> Edit news posts</a>
            </li>
            <li>
              <a href="editevents.php"><i class="fa fa-table fa-fw"></i> Edit events</a>
            </li>
          </ul>
        </div>
        <!-- /.sidebar-collapse -->
      </div>
      <!-- /.navbar-static-side -->
    </nav>

    <div id="page-wrapper">
      <div class="row">
        <div class="col-lg-12">
          <h1 class="page-header">Dashboard</h1>
        </div>
        <!-- /.col-lg-12 -->
      </div>
      <!-- /.row -->
      <div class="row">
        <div class="col-lg-8">
          <div class="panel panel-default">
            <div class="panel-heading">
              <i class="fa fa-edit fa-fw"></i> Create a new post
            </div>
            <!-- /.panel-heading -->
            <div class="panel-body">
              <div id="">
                <form id="addnews" name="addnews" action="news.php" method="post">
                  <div id="postSubject-group" class="form-group">
                    <label for="postSubject">Posting Title</label>
                    <input type="text" name="postSubject" class="form-control" id="postSubject" placeholder="Enter subject" required>
                  </div>

                  <div id="postText-group" class="form-group">
                    <label for="postText">Message</label>
                    <textarea name="postText" id="postText" class="form-control" rows="4" maxlength="280" placeholder="Enter posting" required></textarea>
                    <p class="help-block">(280 character limit)</p>
                  </div>

                  <div class="form-group">
                    <input type="hidden" name="datePosted" value="<?php echo date('m/d/Y'); ?>">
                    <input type="hidden" name="publicVisible" value="1">
                    <input type="hidden" name="na" value="1">
                    <button class="btn btn-default btn-primary" name="addnewss" id="addnews" type="submit">Save new post</button>
                    <!-- <p class="help-block">This will be posted to Club Dante News, Twitter and Facebook</p> -->
                  </div>
                </form>
              </div>
            </div>
            <!-- /.panel-body -->
          </div>
            <!-- /.panel -->
          <div class="panel panel-default new-event">
            <div class="panel-heading">
              <i class="fa fa-calendar-o fa-fw"></i> Create a new event
            </div>
            <!-- /.panel-heading -->
            <div class="panel-body">
              <div class="row">
                <div class="col-lg-12">
                  <form id="addevent" name="addevent" action="events.php" method="post">
                    <div class="form-group">
                      <label for="eventsubject">Event title</label>
                      <input type="text" name="eventsubject" class="form-control" id="eventsubject" placeholder="Enter event title" required>
                    </div>
                <div class="form-group">
                  <div class="form-horizontal">
                    <div class="control-group">
                      <label for="date-picker-2" class="control-label">Event date</label>
                      <div class="controls">
                        <div class="input-group">
                          <input id="date-picker-2" type="text" class="date-picker form-control" name="eventdate" placeholder="Pick an event date">
                          <label for="date-picker-2" class="input-group-addon btn"><span class="glyphicon glyphicon-calendar"></span></label>
                        </div>
                        <span id="helpBlock" class="help-block">Use the event date format of "<?php echo date('m/d/Y'); ?>"</span>
                      </div>
                    </div>
                  </div>
                </div>
                    <div class="form-group">
                      <label for="eventprice">Event pricing information</label>
                      <input type="text" name="eventprice" class="form-control" id="eventprice" placeholder="ex: Event is $20 per person" required>
                    </div>
                    <div class="form-group">
                      <label for="eventtime">Event time information</label>
                      <input type="text" name="eventtime" class="form-control" id="eventtime" placeholder="ex: Cocktails @ 5pm, Dinner @ 7pm" required>
                    </div>
                    <div class="form-group">
                      <label for="eventdesc">Event description</label>
                      <textarea name="eventdesc" id="eventdesc" class="form-control" rows="10" placeholder="Enter event description" required></textarea>
                    </div>
                    <div class="form-group">
                      <label for="eventopen">Event registration</label>
                      <select name="eventopen" id="eventopen" class="form-control">
                        <option value="2">Registration is Pending</option>
                        <option value="0">Registration is open</option>
                        <option value="1">Registration is closed</option>
                       </select>
                    </div>
                    <div class="form-group">
                      <label for="eventprivate">This event is:</label>
                      <select name="eventprivate" id="eventprivate" class="form-control">
                        <option value="0">Open to the public</option>
                        <option value="1">Members only</option>
                       </select>
                    </div>
                    <div class="form-group">
                      <input type="hidden" name="ca" value="1">
                    <input type="hidden" name="dateposted" value="<?php echo date('m/d/Y'); ?>">
                      <button class="btn btn-default btn-primary" type="submit">Save new event</button>
                    </div>
                  </form>
                </div>
                <!-- /.col-lg-4 (nested) -->
                <!-- <div class="col-lg-8"> -->
                  <!-- <div id="morris-bar-chart"></div> -->
                <!-- </div> -->
                <!-- /.col-lg-8 (nested) -->
              </div>
              <!-- /.row -->
            </div>
            <!-- /.panel-body -->
          </div>
          <!-- /.panel -->
        </div>
        <!-- /.col-lg-8 -->
        <div class="col-lg-4">
            <div class="panel panel-default">
                <div class="panel-heading">
                    <i class="fa fa-dashboard fa-fw"></i> &nbsp;
                </div>
                <!-- /.panel-heading -->
                <div class="panel-body">
                    <div class="list-group">
                        <a href="#" class="list-group-item">
                            <i class="fa fa-file-text-o fa-fw"></i> Total News Posts
                            <span class="pull-right text-muted small"><em><?php echo count($newsList); ?></em>
                            </span>
                        </a>
                        <a href="#" class="list-group-item">
                            <i class="fa fa-calendar fa-fw"></i> Total Events
                            <span class="pull-right text-muted small"><em><?php echo count($eventList); ?></em>
                            </span>
                        </a>
                    </div>
                    <!-- /.list-group -->
                    <!-- <a href="#" class="btn btn-default btn-block">View All Alerts</a> -->
                </div>
                <!-- /.panel-body -->
            </div>
            <!-- /.panel -->

        </div>
        <!-- /.col-lg-4 -->
      </div>
        <!-- /.row -->
    </div>
    <!-- /#page-wrapper -->

  </div>
  <!-- /#wrapper -->

  <!-- jQuery -->
  <!-- <script src="bower_components/jquery/dist/jquery.min.js"></script> -->



  <!-- Metis Menu Plugin JavaScript -->
  <!-- // <script src="bower_components/metisMenu/dist/metisMenu.min.js"></script> -->

  <!-- Morris Charts JavaScript -->
  <!-- // <script src="bower_components/raphael/raphael-min.js"></script> -->
  <!-- // <script src="bower_components/morrisjs/morris.min.js"></script> -->
  <!-- // <script src="js/morris-data.js"></script> -->

  <!-- Custom Theme JavaScript -->
  <script src="dist/js/sb-admin-2.js"></script>

</body>

</html>
