<?php

require 'medoo.config.php';

$datas = $database->query("SELECT
  danteclubcalendarid,
  dateposted,
  eventsubject,
  eventdate,
  eventprice,
  eventtime,
  eventdesc,
  eventopen,
  eventprivate FROM danteclubcalendar ORDER BY STR_TO_DATE(eventdate,'%m/%d/%Y') ASC")->fetchAll();

?>

<!DOCTYPE html>
<html lang="en">ave
  <head>
    <meta http-equiv="content-type" content="text/html; charset=UTF-8">
    <meta charset="utf-8">
    <title>Dante Club | Members</title>

    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <link href="css/bootstrap.min.css" rel="stylesheet">
    <!--[if lt IE 9]-->
      <script src="//html5shim.googlecode.com/svn/trunk/html5.js"></script>
    <!--[endif]-->
    <link href="css/styles.css" rel="stylesheet">

    <link href='http://fonts.googleapis.com/css?family=Raleway:700,100,400' rel='stylesheet' type='text/css'>
    <!-- <link href='http://fonts.googleapis.com/css?family=Titillium+Web:400,600,300' rel='stylesheet' type='text/css'> -->
    <!-- <link href='http://fonts.googleapis.com/css?family=Lato:300,400,700' rel='stylesheet' type='text/css'> -->
    <!-- <link href='http://fonts.googleapis.com/css?family=Raleway:400,300,700' rel='stylesheet' type='text/css'> -->

    <style type="text/css">
      body {
        font-family: 'Raleway', sans-serif;
        color: #fff;
        background-color: #000;
        background-image: url('images/darkwood.png');
      }
      a:link { color: #fff; }
      a:visited { color: #fff; }
      a:active { color: #fff; }
      a:hover, a:focus { color: #fff; }
      h1, h2, h3, h4, h5, h6 {
        font-family: "Raleway";
        font-weight: 300;
      }
      .navbar-header button {
        border: none;
      }
      .navbar-default {
        background: transparent;
      }
      ul.nav a:link, ul.nav a:visited, ul.nav a:active {
        color: #fff !important;
      }
      ul.nav a:hover, ul.nav a:active {
        background-color: inherit !important;
      }
      .navbar-default {
        border: none;
      }
      .navbar {
        background-image: url('images/darkwood.png') !important;
        /*background-color: #f00 !important;*/
      }
      .nav>li.active>a,.nav>li.active>a:hover,.nav>li.active>a:focus {
        color: #555;
        background-color: #00ff00;
        border: 1px solid #ddd;
        border-bottom-color:transparent;
        cursor:default;
      }
      #headerwrap {
        margin-top: 70px;
      }
      .page-header, .row, .container, .container-fluid {
        border: none;
      }
      .page-upper {
        /*background-color: #f5f5f5;*/
        margin-bottom: 40px;
        /*padding-top: 40px;*/
        /*padding-bottom: 40px;*/
      }
      .page-upper h2 {
        text-transform: uppercase;
        font-size: 3em;
      }
      .page-footer {
        background-color: #333;
        padding-top: 20px;
        padding-bottom: 20px;
        padding-left: 40px;
        padding-right: 40px;
      }
      .map {
        padding-top: 84px;
        min-height: 370px;
      }
      .sticky-footer {
        /*background-color: #222;*/
        padding-top: 16px;
      }
      .sticky-footer, .sticky-footer a:link, .sticky-footer a:visited, .sticky-footer a:active {
        font-size: 0.9em;
        color: #999;
      }
      /* Navigation */
      .dante-nav a:link, .dante-nav a:visited, .dante-nav a:active, .dante-nav a:focus {
        color: #fff;
      }
      .dante-nav {
        padding-bottom: 6px;
        padding-left: 3.2%;
      }
      .dante-nav table {
        /*background-color: #f00;*/
        width: 960px;
        /*padding: 0;*/
        margin: 0 auto;
      }
      .dante-nav td {
        vertical-align: bottom;
      }
      .dante-nav2 {
        display: none;
      }
      .cal-box {
        /*background-color: #ff0;*/
      }
      @media screen and (max-width:1200px) {
      }
      @media screen and (max-width:990px) {
        .lower-logo, .footer-map {
          padding-top: 40px;
        }
        .newsletter {
          padding-top: 60px;
        }
        .sticky-footer {
          margin-bottom: 16px;
        }
/*        .page-upper-c, .page-upper-r {
          padding-top: 20px;
        }*/
        /* Navigation */
        .dante-nav table {
          display: none;
        }
        .dante-nav2 {
          display: inline;
          list-style-type: none;
        }
        .nav {
          padding-top: 16px !important;
        }
      }
      @media screen and (max-width:769px) {
        .page-upper h2 {
          font-size: 24px;
        }
        .nav-logo {
          display: none;
        }
        #headerwrap {
          margin-top: 40px;
        }
        .btn-news {
          margin: 0 auto;
          width: 100px;
        }
        /* Navigation */
        .hideme {
          display: none;
        }
      }

      /* Index Specific CSS */

      .col-wrapper h2 {
        font-weight: 300;
      }
      .facilities, .food, .events {
        font-size: 1.2em;
        /*font-weight: 100;*/
      }
      .facilities-p, .food-p, .events-p {
        font-weight: 100;
      }
      .page-upper h2 {
        font-size: 2.8em;
      }
      .page-upper p, .page-upper-l li {
        font-weight: 100;
      }
      .page-upper-l, .page-upper-r {
        /*background-color: #ff0;*/
      }
      .page-upper-l {
        /*background-color: #f00;*/
      }
      .page-upper-r {
        /*background-color: #ff0;*/
      }
      .page-upper-l h4 {
        font-size: 1.8em;
        font-weight: 200;
      }
      ul {
        list-style: none;
        padding: 0;
      }
      .page-upper li {
        padding-top: 10px;
        padding-bottom: 10px;
      }
      .the-history {
        width: 90%;
        margin: 0 auto;
        padding-top: 10px;
        font-size: 1.2em;
        font-family: 'Raleway';
        font-weight: 300;
      }
      .hr-500 {
        width: 50%;
      }
      .page-lower {
        padding-top: 60px;
        padding-bottom: 60px;
      }
      .middle-text {
        padding-top: 20px;
      }
      .uppercase {
        text-transform: uppercase;
      }
      .middle-text p {
        font-weight: 100;
      }
      .clubnews {
        width: 80%;
        margin: 0 auto;
      }
      .news-row {
        padding-bottom: 60px;
      }
      .news-subject h3 {
        font-size: 1.2em;
        text-transform: uppercase;
      }
      .news-date {
        padding-top: 26px;
      }
      .page-numbers {
        /*background-color: #f00;*/
        margin: 0 auto;
        width: 80%;
      }
      .page-numbers a:link, .page-numbers a:visited, .page-numbers a:active, .page-numbers a:focus {
       color: #fff;
      }
      .selected {
        color: #999;
      }
      .date-flag {
        width: 112px;
        height: 70px;
        /*background-color: #ffcc00;*/
        background: url('images/date-flag.jpg');
        padding: 0;
        margin: 0;
        margin-top: 6px;
        /*float: right !important;*/
      }
      .date-flag h3 {
        margin: 0;
        padding-top: 26px;
        color: #000;
        font-size: 1.2em;
        font-weight: 600;
      }
      .side-box-left {
        padding-bottom: 40px;
      }
      .side-box-left h4 {
        font-size: 1.8em;
        padding-bottom: 20px;
      }
      .side-box-left li {
        padding-top: 10px;
        padding-bottom: 10px;
        font-weight: 100;
      }
      .side-box-right {
        /*background-color: #ff0;*/
        padding-left: 50px;
      }
       .event-box button {
        width: 140px;
        background: transparent;
        text-transform: uppercase;
        color: #fff;
        margin-top: 10px;
      }
      .event-box {
        margin-top: 0px;
        padding-bottom: 30px;
      }
      .event-title {
        padding-top: 6px;
        font-size: 1.1em;
        font-weight: 700;
      }
      .modal {
        /*background-color: #ff0;*/
        /*color: #000;*/
      }
      .modal-content {
        /*background-color: #f00;*/
        background: url('images/darkwood.png');
        color: #fff;
      }
      .modal button {
        width: 200px;
        background: transparent;
        text-transform: uppercase;
        color: #fff;
      }
      .modal-body p {
        padding-top: 10px;
        padding-bottom: 10px;
      }
      .modal-body h3 {
        font-size: 1.8em;
      }
      .price {
        font-size: 1.5em;
      }
      .time {
        font-size: 1.2em;
      }
      .page-upper button {
        width: 180px;
        background: transparent;
        text-transform: uppercase;
        margin-left: 18px;
        margin-right: 18px;
        margin-top: 40px;
        margin-bottom: 40px;
        color: #fff;
      }
      /* End Index CSS */

input[type=submit] {
        width: 200px;
        background: transparent;
        text-transform: uppercase;
        color: #fff;
        margin-bottom: 20px;
        @btn-default;
}
    </style>
  </head>
  <body>

    <!-- Wrap all page content here -->

    <div id="wrap">
      <div class="navbar navbar-default navbar-fixed-top dante-nav">
        <div class="container">
          <div class="navbar-header">
            <button type="button" class="navbar-toggle" data-toggle="collapse" data-target=".navbar-collapse">
              <!-- <span class="icon-bar"></span>
              <span class="icon-bar"></span>
              <span class="icon-bar"></span> -->
              <img src="images/nav-flags.png">
            </button>
          <!-- <a class="navbar-brand" href="#">Project name</a> -->
          </div>
          <!-- nav bar collapse -->
          <div class="collapse navbar-collapse dante-nav-">
            <div class="nav nav-justified navigation text-center uppercase">
              <table>
<!--
                <tr>
                  <td><a href="index.html">Home</a></td>
                  <td><a href="menu.html">Menu</a></td>
                  <td><a href="about.html">About the Club</a></td>
                  <td><a href="catering.html">Catering</a></td>
                  <td><img src="images/top-logo.png"></td>
                  <td><a href="events.html">Special Events</a></td>
                  <td><a href="calendar.php">Event Calendar</a></td>
                  <td><a href="contact.html">Contact</a></td>
                </tr>
              </table>
              <ul class="dante-nav2 list-inline">
                <li><a href="index.html">Home</a></li>
                <li><a href="menu.html">Menu</a></li>
                <li><a href="about.html">About the Club</a></li>
                <li><a href="catering.html">Catering</a></li>
                <li><img src="images/nav-flags.png" class="hideme"></li>
                <li><a href="events.html">Special Events</a></li>
                <li><a href="calendar.html">Event Calendar</a></li>
                <li><a href="contact.html">Contact</a></li>
              </ul>
            </div>
-->
		<tr>
                  <td><a href="index.html">Home</a></td>
                  <td><a href="menu.html">Menu</a></td>
                  <td><a href="about.html">About the <br>Dante Club</a></td>
                  <td><a href="catering.html">Catering</a></td>
                  <td><img src="images/top-logo.png"></td>
                  <td><a href="events.html">Special <br>Events</a></td>
                  <td><a href="calendar.php">Event <br>Calendar</a></td>
                  <td><a href="contact.html">Contact</a></td>
                  <td><a href="members.php">Members <br>Area</a></td>
                  <td><a href="donation.html">Donations</a></td>
                </tr>
              </table>
              <ul class="dante-nav2 list-inline">
<!--
                <li>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</li>
-->
                <li><a href="index.html">Home</a></li>
                <li><a href="menu.html">Menu</a></li>
                <li><a href="about.html">About the <br>Dante Club</a></li>
                <li><a href="catering.html">Catering</a></li>
                <li><img src="images/nav-flags.png" class="hideme"></li>
                <li><a href="events.html">Special <br>Events</a></li>
                <li><a href="calendar.php">Event <br>Calendar</a></li>
                <li><a href="contact.html">Contact</a></li>
                <li><a href="members.php">Members <br>/Area</a></li>
                <!--<li><a href="donation.html">Donations</a></li> -->
              </ul>
            </div>

          <!--/.nav-collapse -->
          </div>
        </div>
      </div>

      <!-- Begin page content -->
      <header class="page-header" id="headerwrap">

        <!-- Removed Calendar Picture (Remove comments to reinstate)
	<img src="images/calendar-header-lg.jpg" class="img-responsive center-block" alt="Dante Club Sacramento" title="Dante Club Sacramento">
	-->

      </header>

<!--       <div id="headerwrap" class="container main-header">
        <div class="page-header">
          <header class="clearfix text-center">
            <img src="images/main_header.png" class="img-relative center-block">
          </header>
        </div>
      </div>
-->

            <div class="container page-upper uppercase">
              <div class="row text-center">
                <div class="col-md-12 text-center">
<br>
                  <h1>Members Home</h1>
                  <hr class="hr-500 center-block">
                </div>

                <p><!--<a href="members-cal.php"><button class="btn btn-default btn-members-cal">Members Calendar</button></a> -->
		<a href="members-inferno.html"><button class="btn btn-default btn-members-inferno">Inferno Newsletter</button></a>
<!--
		<a href="members-bylaws.html"><button class="btn btn-default btn-members-bylaws">Member Bylaws</button></a>
-->
		<a href="assets/DCBylaws-8-15-17.pdf"><button class="btn btn-default btn-members-bylaws">Member Bylaws</button></a>

<!--
		<a href="auxiliary.html"><button class="btn btn-default btn-members-bylaws">Auxiliary</button></a></p>
-->

<!--In the case of an error due to Aplus upgrades
<br><br>
<b><center>WE ARE CURRENTLY EXPERIENCING A TECHNICAL PROBLEM WITH OUR RESERVATION PAGE<br>
IF YOU WISH TO MAKE A RESERVATION FOR AN UPCOMING EVENT,<br>
PLEASE CALL THE DANTE CLUB AT 916-925-8230<br>
WE WILL HAVE THE WEBSITE UP AND RUNNING AS SOON AS POSSIBLE!</center></b><br>
-->
              </div>
            </div>

      <div class="container">
        <div class="col-md-12">
          <div class="row">
            <div class="col-md-6 text-center side-box-left uppercase">

               <h3><u>Member's links</u></h3>

              <ul>
                <a href="memop.html"><li>MEMBERSHIP OPPORTUNITY</li></a>

                <a href="donation.html"><li>SCHOLARSHIP & BUILDING FUND DONATIONS</li></a>
<!--
                <a href="EventCalendar.html"><li>CALENDAR&nbsp;&nbsp; (Authorized Users Only)</li></a>
                  <a href="assets/bgworksheet-5-18-16.xls" target="blank"><li>BUILDINGS & GROUNDS (XLS)</li></a>

                <a href="assets/DC-2018-ScholarshipApplication.pdf"><li>SCHOLARSHIP APPLICATION<br>
                               (Applications Must be Received by 3/31/18)</li></a>
-->
<!--
                 <a href="scholarapp.html"><li>SCHOLARSHIP APPLICATION</li></a>
-->


              </ul>

              <br />
              <hr>
              <br />


              <h3><u>Save the Dates</u></h3>
              <ul>

<!--
                <li>Crab Feed - January 22nd - $40</li>
                <li>Fizz Brunch - February 21st $25</li>
                <li>Cioppino - March 5th - $45</li>
                <li>Easter Celebration and Brunch - March 26th - $20</li>
                <li>Mother's Day Brunch - May 7th - $25</li>
                <li>Viva Vino (Wine tasting) - May 22nd - $TBD</li>
                <li>Father's Day BBQ - June 18th - $25</li>
                <li>River Cats Game - Italian Heritage Night<br>
                    June 30, 2016 - Game Time 7:05pm</li>
                <li>Vic Martinelli Memorial Golf Tournament - August 13, 2016<br>
                       Golf, Dinner and Prizes $85; Golf Only $65; Dinner Only $25<br>
                       (Alister MacKenzie Golf Course)</li>

		<li>Mangia Italiano/90th Anniversary Celebration<br>September 17, 2016 - $45</li>
                <li>Stag Sausage Feed - October 13, 2016 - $25</li>
		<li>Christmas Dinner - December 18, 2016 - Free to Members</li>
		<li>New Year's Eve Party - December 31st - $45 (Cancelled)</li>
		<li>Crab Feed - January 21, 2017 - $45.00</li>
		<li>Cioppino Dinner - April 1, 2017 - $48</li>
                <li>Easter Celebration and Brunch - April 15, 2017 - Free Egg Hunt<br>
			Brunch - $25 Adults; $10 Kids 5-10 yrs</li>
                <li>Mother's Day Brunch - May 13, 2017 26th - $25 Adults; $10 Kids 5-10 yrs</li>
                <li>Viva Vino (Wine and Beer Tasting) - May 21, 2017<br>
			$25 prepaid; $30 at the event.</li>
		<li>Father's Day BBQ - June 17, 2017 - Adults $25, Kids $13</li>
		<li>Vic Martinelli Memorial Golf Tournament - August 12, 2017<br>
                       Golf, Dinner and Prizes $85; Additional Guest Dinner $20</li>
		<li>Italian Heritage Night at the River Cats - August 31, 2017 - $19</li>
		<li>Mangia Italiano! - September 24, 2017 - Adults $45; Kids 5-12 $23</li>
		<li>Stag Sausage Feed - October 12, 2017 - $20</li>
		<li>Christmas Dinner - December 17, 2017 - Adults $32; Under 12 $20</li>
		<li>Crab Feed - January 20, 2018 - Adults $45; Under 12 $25</li>
		<li>Cioppino Dinner - March 17 2018 - $48</li>
		<li>Easter Celebration - March 31, 2018 - Free to Members and Family</li>
		<li>Mother's Day Brunch - May 12, 2018 - Adults $25; Kids, 10 and Under $12.50</li>
		<li>Viva Vino & Beer - June 10, 2018 </li> <!-- $25 -->

		<li>Italian Heritage Night at the River Cats Game - June 21, 2018</li> <!-- $19 -->
		<li>Annual Golf Tournament - August 4, 2018 - Golf & Dinner </li> <!-- $85 -->
		<li>Mangia Italiano - Date TBD</li>
		<li>Annual Stag Sausage Feed - October 11, 2018 </li> <!-- $20 -->
		<li>Christmas Dinner - December 23, 2018 </li> <!-- TBD -->
		<li>New Years Eve Party - December 31, 2018 </li> <!-- TBD -->

              </ul>
              </div>

<!--
              </ul>

              <br />
              <hr>
              <br />


              <h4>2015 Save the dates</h4>
              <ul>

                <li>Fizz Brunch - February 15th - $20</li>
                <li>Cioppino - March 7th - $TBD</li>
                <li>Easter Celebration - April 4th - See Events Page</li>
                <li>Viva Vino (Wine tasting) - May 17th - $15 before April 1; $20 After</li>
                <li>Father's Day BBQ - June 21 - $20 Adults; $10 Kids (12 and under)</li>
		<li>Merlo Family Vinyard Wine Pairing Dinner - July 30th - $60</li>
                <li>Stag Sausage Feed - October 10th - $25</li>
                <li>Mangia Italiano - November 14th - $TBD</li>
                <li>Vic Martinelli Memorial Golf Tournament - August 15, 2015<br>
                       Golf, Dinner and Prizes $65; Golf Only $45; Dinner Only $20<br>
                       (Alister MacKenzie Golf Course)</li>
                <!-- <li></li>
              </ul>
-->

            <div class="col-md-6 side-box-right uppercase">
              <?php
                foreach($datas as $clubEvents) {
                  // start the loop

                  $products[] = array(
                    'danteclubcalendarid' => $clubEvents['danteclubcalendarid'],
                    'dateposted' => $clubEvents['dateposted'],
                    'eventsubject' => $clubEvents['eventsubject'],
                    'eventdesc' => $clubEvents['eventdesc'],
                    'eventdate' => $clubEvents['eventdate'],
                    'eventprice' => $clubEvents['eventprice'],
                    'eventtime' => $clubEvents['eventtime'],
                    'eventopen' => $clubEvents['eventopen'],
                    'eventprivate' => $clubEvents['eventprivate'],
                  );

                } // end the loop


                if (empty($products)) {
                  echo "Notice: Your database appears to be empty.";
                } else {
                  // If we have an array with items
                  if (count($products)) {
                    // Create the pagination object
                    $pagination = new pagination($products, (isset($_GET['page']) ? $_GET['page'] : 1), 8);
                    // Decide if the first and last links should show
                    $pagination->setShowFirstAndLast(false);
                    // You can overwrite the default seperator
                    $pagination->setMainSeperator(' | ');
                    // Parse through the pagination class
                    $productPages = $pagination->getResults();
                    // If we have items
                    if (count($productPages) != 0) {
                      // Create the page numbers
                      echo $pageNumbers = '<div class="numbers">'.$pagination->getLinks($_GET).'</div>';
                      // Loop through all the items in the array

                      foreach ($productPages as $productArray) {
                        // Show the information about the item
                        // echo '<p><b>'.$productArray['postSubject'].'</b> &nbsp;</p>';

                        // $date_now = date("m/d/Y"); // this format is string comparable
                        // if ($date_now > $productArray['eventdate']) {
              ?>
              <div class="row event-box">
                <div class="col-md-4 date-flag text-center">
                  <h3><?php echo $productArray['eventdate']; ?></h3>
                </div>
                <div class="col-md-8">
                  <div class="event-title"><?php echo $productArray['eventsubject']; ?></div>
                  <div><button class="btn btn-default" data-toggle="modal" data-target="#myModal-<?php echo $productArray['danteclubcalendarid']; ?>">Read More</button></div>
                </div>
              </div>

              <!-- start modal code -->

              <div class="modal fade" id="myModal-<?php echo $productArray['danteclubcalendarid']; ?>" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
                <div class="modal-dialog">
                  <div class="modal-content">
                    <div class="modal-header text-center">
                      <!-- <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button> -->
                      <h2 class="modal-title" id="myModalLabel"><?php echo html_entity_decode($productArray['eventsubject']); ?></h2>
                    </div>
                    <div class="modal-body text-center">
                      <p class="date"><h3><?php echo $productArray['eventdate']; ?></h3></p>
                      <p class="price"><?php echo html_entity_decode($productArray['eventprice']); ?></p>
                      <p class="time"><?php echo html_entity_decode($productArray['eventtime']); ?></p>
                      <p class="desc"><?php echo html_entity_decode($productArray['eventdesc']); ?></p>
                      <p class="reserv">Reservations for this event are <?php if($productArray['eventopen'] == '1'){ echo 'closed'; } elseif ($productArray['eventopen'] == '2') { echo 'pending'; } else { echo 'open'; } ?></p>
                    </div>
                    <div class="modal-footer">
                      <button type="button" class="btn btn-default center-block" data-dismiss="modal">[X] &nbsp;&nbsp; Close</button>
                    </div>
                  </div>
                </div>
              </div>
              <?php
                  }
                  // print out the page numbers beneath the results
                  echo $pageNumbers;
                }
              }
            }
              ?>
            <!-- end loop -->
            </div>
          </div>
        </div>
      </div>

      <div class="container-fluid page-footer">
        <div class="container page-footer">
          <div class="row">
            <div class="col-md-4 follow-us">
              <p class="uppercase">About The Club</p>
              <hr>
              <!-- <p>The Dante Club's central location and well-stated building has hosted generations of Sacramento's local families and a number of its "royalty" for memorable events.</p> -->
              <p>The Dante Club is centrally located with ample parking and directly off Fair Oaks Boulevard.</p>
              <p>Let the professional staff coordinate your next event: Wedding, Retirement Party, Birthday Party, Business Meeting, Reunions, Monthly Groups, Fundraiser, Quinceanera.</p>
            </div>
            <div class="col-md-4 newsletter">
              <p class="uppercase">Latest News</p>
              <hr>
              <p>We love sharing our recent news. If you would like to see all our recent posts, please click the button below.</p>
              <p class="btn-news"><a href="news.php"><button type="button" class="btn-info btn-sm btn-default">READ MORE</button></a></p>
              <br />
              <div class="social-media">
                <!-- <div class="col-xs-2"><a href="#"><img src="images/gplus.png" alt="Visit us on Google Plus"></a></div> -->
                <!-- <div class="col-xs-2"><a href="#"><img src="images/unknown.png" align="Visit us at ..." title="Visit us at ..."></a></div> -->
                <div class="col-md-12"><a href="https://www.facebook.com/pages/Dante-Club/109441672431639"><img src="images/fb.png" alt="Visit us on Facebook" title="Visit us on Facebook"></a> &nbsp; &nbsp; <a href="https://www.facebook.com/pages/Dante-Club/109441672431639">Visit us on Facebook</a></div>
                <!-- <div class="col-xs-2"><a href="#"><img src="images/Be.png" alt="Visit us at ..." title="Visit us on ..."></a></div> -->
                <!-- <div class="col-xs-2"><a href="#"><img src="images/twitter.png" alt="Visit us on Twitter" title="Visit us on Twitter"></a></div> -->
                <!-- <div class="col-xs-2"><a href="#"><img src="images/in.png" alt="Visit us at Linked In" title="Visit us at Linked In"></a></div> -->
              </div>
            </div>
            <div class="col-md-4 text-center footer-map">
              <a href="contact.html"><img src="images/map.png" alt="Google Maps" title="Google Maps"></a>
            </div>
          </div>
        </div>
      </div>
    </div>

    <!-- // end page wrap -->

    <div id="footer" class="sticky-footer">
      <div class="container-fluid text-center">
        <div class="col-md-6">Copyright &copy; 2015 | Dante Club, all rights reserved.</div>
        <div class="col-md-6 uppercase"><a href="members.php">Members Area</a> | <a href="privacy.html">Privacy Policy</a> | <a href="alighieri.html">Dante alighieri</a> | <a href="contact.html">Contact</a></div>
      </div>
    </div>

    <!-- script references -->

    <script src="http://ajax.googleapis.com/ajax/libs/jquery/2.0.2/jquery.min.js"></script>
    <script src="js/bootstrap.min.js"></script>

  </body>
</html>
